/* Generated SBE (Simple Binary Encoding) message codec. */
package io.camunda.zeebe.clustering.management;

import org.agrona.MutableDirectBuffer;
import org.agrona.DirectBuffer;
import org.agrona.sbe.*;

@SuppressWarnings("all")
public final class PushDeploymentRequestEncoder implements MessageEncoderFlyweight
{
    public static final int BLOCK_LENGTH = 10;
    public static final int TEMPLATE_ID = 2;
    public static final int SCHEMA_ID = 5;
    public static final int SCHEMA_VERSION = 2;
    public static final java.nio.ByteOrder BYTE_ORDER = java.nio.ByteOrder.LITTLE_ENDIAN;

    private final PushDeploymentRequestEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;

    public int sbeBlockLength()
    {
        return BLOCK_LENGTH;
    }

    public int sbeTemplateId()
    {
        return TEMPLATE_ID;
    }

    public int sbeSchemaId()
    {
        return SCHEMA_ID;
    }

    public int sbeSchemaVersion()
    {
        return SCHEMA_VERSION;
    }

    public String sbeSemanticType()
    {
        return "";
    }

    public MutableDirectBuffer buffer()
    {
        return buffer;
    }

    public int initialOffset()
    {
        return initialOffset;
    }

    public int offset()
    {
        return offset;
    }

    public PushDeploymentRequestEncoder wrap(final MutableDirectBuffer buffer, final int offset)
    {
        if (buffer != this.buffer)
        {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        limit(offset + BLOCK_LENGTH);

        return this;
    }

    public PushDeploymentRequestEncoder wrapAndApplyHeader(
        final MutableDirectBuffer buffer, final int offset, final MessageHeaderEncoder headerEncoder)
    {
        headerEncoder
            .wrap(buffer, offset)
            .blockLength(BLOCK_LENGTH)
            .templateId(TEMPLATE_ID)
            .schemaId(SCHEMA_ID)
            .version(SCHEMA_VERSION);

        return wrap(buffer, offset + MessageHeaderEncoder.ENCODED_LENGTH);
    }

    public int encodedLength()
    {
        return limit - offset;
    }

    public int limit()
    {
        return limit;
    }

    public void limit(final int limit)
    {
        this.limit = limit;
    }

    public static int partitionIdId()
    {
        return 0;
    }

    public static int partitionIdSinceVersion()
    {
        return 0;
    }

    public static int partitionIdEncodingOffset()
    {
        return 0;
    }

    public static int partitionIdEncodingLength()
    {
        return 2;
    }

    public static String partitionIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int partitionIdNullValue()
    {
        return 65535;
    }

    public static int partitionIdMinValue()
    {
        return 0;
    }

    public static int partitionIdMaxValue()
    {
        return 65534;
    }

    public PushDeploymentRequestEncoder partitionId(final int value)
    {
        buffer.putShort(offset + 0, (short)value, java.nio.ByteOrder.LITTLE_ENDIAN);
        return this;
    }


    public static int deploymentKeyId()
    {
        return 1;
    }

    public static int deploymentKeySinceVersion()
    {
        return 0;
    }

    public static int deploymentKeyEncodingOffset()
    {
        return 2;
    }

    public static int deploymentKeyEncodingLength()
    {
        return 8;
    }

    public static String deploymentKeyMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long deploymentKeyNullValue()
    {
        return 0xffffffffffffffffL;
    }

    public static long deploymentKeyMinValue()
    {
        return 0x0L;
    }

    public static long deploymentKeyMaxValue()
    {
        return 0xfffffffffffffffeL;
    }

    public PushDeploymentRequestEncoder deploymentKey(final long value)
    {
        buffer.putLong(offset + 2, value, java.nio.ByteOrder.LITTLE_ENDIAN);
        return this;
    }


    public static int deploymentId()
    {
        return 2;
    }

    public static String deploymentCharacterEncoding()
    {
        return "UTF-8";
    }

    public static String deploymentMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int deploymentHeaderLength()
    {
        return 4;
    }

    public PushDeploymentRequestEncoder putDeployment(final DirectBuffer src, final int srcOffset, final int length)
    {
        if (length > 2147483647)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
        buffer.putBytes(limit + headerLength, src, srcOffset, length);

        return this;
    }

    public PushDeploymentRequestEncoder putDeployment(final byte[] src, final int srcOffset, final int length)
    {
        if (length > 2147483647)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
        buffer.putBytes(limit + headerLength, src, srcOffset, length);

        return this;
    }

    public PushDeploymentRequestEncoder deployment(final String value)
    {
        final byte[] bytes;
        try
        {
            bytes = null == value || value.isEmpty() ? org.agrona.collections.ArrayUtil.EMPTY_BYTE_ARRAY : value.getBytes("UTF-8");
        }
        catch (final java.io.UnsupportedEncodingException ex)
        {
            throw new RuntimeException(ex);
        }

        final int length = bytes.length;
        if (length > 2147483647)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
        buffer.putBytes(limit + headerLength, bytes, 0, length);

        return this;
    }

    public String toString()
    {
        if (null == buffer)
        {
            return "";
        }

        return appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(final StringBuilder builder)
    {
        if (null == buffer)
        {
            return builder;
        }

        final PushDeploymentRequestDecoder decoder = new PushDeploymentRequestDecoder();
        decoder.wrap(buffer, initialOffset, BLOCK_LENGTH, SCHEMA_VERSION);

        return decoder.appendTo(builder);
    }
}
