/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.bootstrap;

import io.atomix.cluster.AtomixCluster;
import io.camunda.zeebe.broker.bootstrap.AbstractBrokerStartupStep;
import io.camunda.zeebe.broker.bootstrap.BrokerStartupContext;
import io.camunda.zeebe.broker.clustering.AtomixClusterFactory;
import io.camunda.zeebe.broker.clustering.ClusterServicesImpl;
import io.camunda.zeebe.util.sched.ConcurrencyControl;
import io.camunda.zeebe.util.sched.future.ActorFuture;

class ClusterServicesStep
extends AbstractBrokerStartupStep {
    ClusterServicesStep() {
    }

    public String getName() {
        return "Cluster Services (Start)";
    }

    @Override
    void startupInternal(BrokerStartupContext brokerStartupContext, ConcurrencyControl concurrencyControl, ActorFuture<BrokerStartupContext> startupFuture) {
        AtomixCluster atomix = AtomixClusterFactory.fromConfiguration(brokerStartupContext.getBrokerConfiguration());
        ClusterServicesImpl clusterServices = new ClusterServicesImpl(atomix);
        brokerStartupContext.setClusterServices(clusterServices);
        clusterServices.start().whenComplete((ok, error) -> {
            if (error != null) {
                startupFuture.completeExceptionally(error);
            } else {
                startupFuture.complete((Object)brokerStartupContext);
            }
        });
    }

    @Override
    void shutdownInternal(BrokerStartupContext brokerShutdownContext, ConcurrencyControl concurrencyControl, ActorFuture<BrokerStartupContext> shutdownFuture) {
        ClusterServicesImpl clusterServices = brokerShutdownContext.getClusterServices();
        if (clusterServices == null) {
            shutdownFuture.complete((Object)brokerShutdownContext);
            return;
        }
        clusterServices.stop().whenComplete((ok, error) -> {
            if (error != null) {
                shutdownFuture.completeExceptionally(error);
            } else {
                brokerShutdownContext.setClusterServices(null);
                shutdownFuture.complete((Object)brokerShutdownContext);
            }
        });
    }
}

