/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.transport.adminapi;

import io.atomix.raft.partition.RaftPartition;
import io.atomix.raft.partition.RaftPartitionGroup;
import io.atomix.utils.AbstractIdentifier;
import io.camunda.zeebe.broker.partitioning.PartitionManagerImpl;
import io.camunda.zeebe.broker.transport.ApiRequestHandler;
import io.camunda.zeebe.broker.transport.ErrorResponseWriter;
import io.camunda.zeebe.broker.transport.adminapi.ApiRequestReader;
import io.camunda.zeebe.broker.transport.adminapi.ApiResponseWriter;
import io.camunda.zeebe.protocol.record.AdminRequestType;
import io.camunda.zeebe.transport.RequestHandler;
import io.camunda.zeebe.transport.RequestType;
import io.camunda.zeebe.transport.impl.AtomixServerTransport;
import io.camunda.zeebe.util.Either;

public class AdminApiRequestHandler
extends ApiRequestHandler<ApiRequestReader, ApiResponseWriter> {
    private RaftPartitionGroup partitionGroup;
    private final AtomixServerTransport transport;

    public AdminApiRequestHandler(AtomixServerTransport transport) {
        super(new ApiRequestReader(), new ApiResponseWriter());
        this.transport = transport;
    }

    @Override
    protected Either<ErrorResponseWriter, ApiResponseWriter> handle(int partitionId, long requestId, ApiRequestReader requestReader, ApiResponseWriter responseWriter, ErrorResponseWriter errorWriter) {
        if (requestReader.getMessageDecoder().type() == AdminRequestType.STEP_DOWN_IF_NOT_PRIMARY) {
            return this.stepDownIfNotPrimary(responseWriter, partitionId, errorWriter);
        }
        return this.unknownRequest(errorWriter, requestReader.getMessageDecoder().type());
    }

    private Either<ErrorResponseWriter, ApiResponseWriter> unknownRequest(ErrorResponseWriter errorWriter, AdminRequestType type) {
        errorWriter.unsupportedMessage(type, AdminRequestType.values());
        return Either.left((Object)errorWriter);
    }

    private Either<ErrorResponseWriter, ApiResponseWriter> stepDownIfNotPrimary(ApiResponseWriter responseWriter, int partitionId, ErrorResponseWriter errorWriter) {
        if (this.partitionGroup == null) {
            errorWriter.partitionLeaderMismatch(partitionId);
            return Either.left((Object)errorWriter);
        }
        RaftPartition partition = this.partitionGroup.getPartition(partitionId);
        partition.stepDownIfNotPrimary();
        return Either.right((Object)responseWriter);
    }

    public void injectPartitionManager(PartitionManagerImpl partitionManager) {
        this.partitionGroup = (RaftPartitionGroup)partitionManager.getPartitionGroup();
        this.partitionGroup.getPartitionIds().stream().map(AbstractIdentifier::id).forEach(partitionId -> this.transport.subscribe(partitionId.intValue(), RequestType.ADMIN, (RequestHandler)this));
    }
}

