/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.logstreams;

import io.atomix.raft.RaftException;
import io.atomix.raft.storage.log.IndexedRaftLogEntry;
import io.atomix.raft.zeebe.ZeebeLogAppender;
import io.camunda.zeebe.broker.Loggers;
import io.camunda.zeebe.logstreams.storage.LogStorage;
import java.util.NoSuchElementException;

public final class AtomixAppendListenerAdapter
implements ZeebeLogAppender.AppendListener {
    private final LogStorage.AppendListener delegate;
    private final long highestPosition;
    private final long lowestPosition;

    public AtomixAppendListenerAdapter(long lowestPosition, long highestPosition, LogStorage.AppendListener delegate) {
        this.lowestPosition = lowestPosition;
        this.highestPosition = highestPosition;
        this.delegate = delegate;
    }

    public void onWrite(IndexedRaftLogEntry indexed) {
        this.delegate.onWrite(indexed.index());
    }

    public void onWriteError(Throwable error) {
        if (error instanceof NoSuchElementException || error instanceof RaftException.NoLeader) {
            Loggers.LOGSTREAMS_LOGGER.debug("Expected to append block: [lowestPos: {} , highestPos: {}], but failed with {}. This can happen during a leader change.", new Object[]{this.lowestPosition, this.highestPosition, error.getMessage(), error});
            return;
        }
        this.delegate.onWriteError(error);
    }

    public void onCommit(IndexedRaftLogEntry indexed) {
        this.delegate.onCommit(indexed.index());
    }

    public void onCommitError(IndexedRaftLogEntry indexed, Throwable error) {
        this.delegate.onCommitError(indexed.index(), error);
    }
}

