/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.protocol;

import io.camunda.zeebe.broker.protocol.MessageHeaderDecoder;
import io.camunda.zeebe.broker.protocol.MetaAttribute;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.sbe.MessageDecoderFlyweight;

public final class ExporterStateDecoder
implements MessageDecoderFlyweight {
    public static final int BLOCK_LENGTH = 0;
    public static final int TEMPLATE_ID = 1;
    public static final int SCHEMA_ID = 5;
    public static final int SCHEMA_VERSION = 3;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final ExporterStateDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;
    private final StateDecoder state = new StateDecoder(this);

    public int sbeBlockLength() {
        return 0;
    }

    public int sbeTemplateId() {
        return 1;
    }

    public int sbeSchemaId() {
        return 5;
    }

    public int sbeSchemaVersion() {
        return 3;
    }

    public String sbeSemanticType() {
        return "";
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public ExporterStateDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public ExporterStateDecoder wrapAndApplyHeader(DirectBuffer buffer, int offset, MessageHeaderDecoder headerDecoder) {
        headerDecoder.wrap(buffer, offset);
        int templateId = headerDecoder.templateId();
        if (1 != templateId) {
            throw new IllegalStateException("Invalid TEMPLATE_ID: " + templateId);
        }
        return this.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
    }

    public ExporterStateDecoder sbeRewind() {
        return this.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
    }

    public int sbeDecodedLength() {
        int currentLimit = this.limit();
        this.sbeSkip();
        int decodedLength = this.encodedLength();
        this.limit(currentLimit);
        return decodedLength;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static long stateDecoderId() {
        return 0L;
    }

    public static int stateDecoderSinceVersion() {
        return 0;
    }

    public StateDecoder state() {
        this.state.wrap(this.buffer);
        return this.state;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        ExporterStateDecoder decoder = new ExporterStateDecoder();
        decoder.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        int originalLimit = this.limit();
        this.limit(this.initialOffset + this.actingBlockLength);
        builder.append("[ExporterState](sbeTemplateId=");
        builder.append(1);
        builder.append("|sbeSchemaId=");
        builder.append(5);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 3) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(3);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 0) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(0);
        builder.append("):");
        builder.append("state=[");
        int stateOriginalOffset = this.state.offset;
        int stateOriginalIndex = this.state.index;
        StateDecoder state = this.state();
        if (state.count() > 0) {
            while (state.hasNext()) {
                state.next().appendTo(builder);
                builder.append(',');
            }
            builder.setLength(builder.length() - 1);
        }
        state.offset = stateOriginalOffset;
        state.index = stateOriginalIndex;
        builder.append(']');
        this.limit(originalLimit);
        return builder;
    }

    public ExporterStateDecoder sbeSkip() {
        this.sbeRewind();
        StateDecoder state = this.state();
        if (state.count() > 0) {
            while (state.hasNext()) {
                state.next();
                state.sbeSkip();
            }
        }
        return this;
    }

    public static final class StateDecoder
    implements Iterable<StateDecoder>,
    Iterator<StateDecoder> {
        public static final int HEADER_SIZE = 3;
        private final ExporterStateDecoder parentMessage;
        private DirectBuffer buffer;
        private int count;
        private int index;
        private int offset;
        private int blockLength;

        StateDecoder(ExporterStateDecoder parentMessage) {
            this.parentMessage = parentMessage;
        }

        public void wrap(DirectBuffer buffer) {
            if (buffer != this.buffer) {
                this.buffer = buffer;
            }
            this.index = 0;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 3);
            this.blockLength = buffer.getShort(limit + 0, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
            this.count = (short)(buffer.getByte(limit + 2) & 0xFF);
        }

        @Override
        public StateDecoder next() {
            if (this.index >= this.count) {
                throw new NoSuchElementException();
            }
            this.offset = this.parentMessage.limit();
            this.parentMessage.limit(this.offset + this.blockLength);
            ++this.index;
            return this;
        }

        public static short countMinValue() {
            return 0;
        }

        public static short countMaxValue() {
            return 254;
        }

        public static int sbeHeaderSize() {
            return 3;
        }

        public static int sbeBlockLength() {
            return 8;
        }

        public int actingBlockLength() {
            return this.blockLength;
        }

        public int count() {
            return this.count;
        }

        @Override
        public Iterator<StateDecoder> iterator() {
            return this;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.index < this.count;
        }

        public static int positionId() {
            return 0;
        }

        public static int positionSinceVersion() {
            return 0;
        }

        public static int positionEncodingOffset() {
            return 0;
        }

        public static int positionEncodingLength() {
            return 8;
        }

        public static String positionMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            if (MetaAttribute.SEMANTIC_TYPE == metaAttribute) {
                return "long";
            }
            return "";
        }

        public static long positionNullValue() {
            return -1L;
        }

        public static long positionMinValue() {
            return 0L;
        }

        public static long positionMaxValue() {
            return -2L;
        }

        public long position() {
            return this.buffer.getLong(this.offset + 0, ByteOrder.LITTLE_ENDIAN);
        }

        public static int exporterIdId() {
            return 1;
        }

        public static int exporterIdSinceVersion() {
            return 0;
        }

        public static String exporterIdCharacterEncoding() {
            return StandardCharsets.UTF_8.name();
        }

        public static String exporterIdMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            if (MetaAttribute.SEMANTIC_TYPE == metaAttribute) {
                return "string";
            }
            return "";
        }

        public static int exporterIdHeaderLength() {
            return 4;
        }

        public int exporterIdLength() {
            int limit = this.parentMessage.limit();
            return (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        }

        public int skipExporterId() {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            int dataOffset = limit + 4;
            this.parentMessage.limit(dataOffset + dataLength);
            return dataLength;
        }

        public int getExporterId(MutableDirectBuffer dst, int dstOffset, int length) {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            int bytesCopied = Math.min(length, dataLength);
            this.parentMessage.limit(limit + 4 + dataLength);
            this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
            return bytesCopied;
        }

        public int getExporterId(byte[] dst, int dstOffset, int length) {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            int bytesCopied = Math.min(length, dataLength);
            this.parentMessage.limit(limit + 4 + dataLength);
            this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
            return bytesCopied;
        }

        public void wrapExporterId(DirectBuffer wrapBuffer) {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            this.parentMessage.limit(limit + 4 + dataLength);
            wrapBuffer.wrap(this.buffer, limit + 4, dataLength);
        }

        public String exporterId() {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            this.parentMessage.limit(limit + 4 + dataLength);
            if (0 == dataLength) {
                return "";
            }
            byte[] tmp = new byte[dataLength];
            this.buffer.getBytes(limit + 4, tmp, 0, dataLength);
            return new String(tmp, StandardCharsets.UTF_8);
        }

        public static int metadataId() {
            return 2;
        }

        public static int metadataSinceVersion() {
            return 3;
        }

        public static String metadataCharacterEncoding() {
            return StandardCharsets.UTF_8.name();
        }

        public static String metadataMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            if (MetaAttribute.SEMANTIC_TYPE == metaAttribute) {
                return "binary";
            }
            return "";
        }

        public static int metadataHeaderLength() {
            return 4;
        }

        public int metadataLength() {
            if (this.parentMessage.actingVersion < 3) {
                return 0;
            }
            int limit = this.parentMessage.limit();
            return (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        }

        public int skipMetadata() {
            if (this.parentMessage.actingVersion < 3) {
                return 0;
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            int dataOffset = limit + 4;
            this.parentMessage.limit(dataOffset + dataLength);
            return dataLength;
        }

        public int getMetadata(MutableDirectBuffer dst, int dstOffset, int length) {
            if (this.parentMessage.actingVersion < 3) {
                return 0;
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            int bytesCopied = Math.min(length, dataLength);
            this.parentMessage.limit(limit + 4 + dataLength);
            this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
            return bytesCopied;
        }

        public int getMetadata(byte[] dst, int dstOffset, int length) {
            if (this.parentMessage.actingVersion < 3) {
                return 0;
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            int bytesCopied = Math.min(length, dataLength);
            this.parentMessage.limit(limit + 4 + dataLength);
            this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
            return bytesCopied;
        }

        public void wrapMetadata(DirectBuffer wrapBuffer) {
            if (this.parentMessage.actingVersion < 3) {
                wrapBuffer.wrap(this.buffer, this.offset, 0);
                return;
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            this.parentMessage.limit(limit + 4 + dataLength);
            wrapBuffer.wrap(this.buffer, limit + 4, dataLength);
        }

        public String metadata() {
            if (this.parentMessage.actingVersion < 3) {
                return "";
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            this.parentMessage.limit(limit + 4 + dataLength);
            if (0 == dataLength) {
                return "";
            }
            byte[] tmp = new byte[dataLength];
            this.buffer.getBytes(limit + 4, tmp, 0, dataLength);
            return new String(tmp, StandardCharsets.UTF_8);
        }

        public StringBuilder appendTo(StringBuilder builder) {
            if (null == this.buffer) {
                return builder;
            }
            builder.append('(');
            builder.append("position=");
            builder.append(this.position());
            builder.append('|');
            builder.append("exporterId=");
            builder.append('\'').append(this.exporterId()).append('\'');
            builder.append('|');
            builder.append("metadata=");
            builder.append('\'').append(this.metadata()).append('\'');
            builder.append(')');
            return builder;
        }

        public StateDecoder sbeSkip() {
            this.skipExporterId();
            this.skipMetadata();
            return this;
        }
    }
}

