/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.configuration;

import io.camunda.zeebe.broker.system.configuration.ConfigurationEntry;
import java.time.Duration;
import java.util.Objects;

public final class RaftCfg
implements ConfigurationEntry {
    public static final boolean DEFAULT_ENABLE_PRIORITY_ELECTION = true;
    private static final FlushConfig DEFAULT_FLUSH_CONFIG = new FlushConfig(true, Duration.ZERO);
    private boolean enablePriorityElection = true;
    private FlushConfig flush = DEFAULT_FLUSH_CONFIG;

    public boolean isEnablePriorityElection() {
        return this.enablePriorityElection;
    }

    public void setEnablePriorityElection(boolean enablePriorityElection) {
        this.enablePriorityElection = enablePriorityElection;
    }

    public FlushConfig getFlush() {
        return this.flush;
    }

    public void setFlush(FlushConfig flush) {
        this.flush = flush;
    }

    public String toString() {
        return "RaftCfg{enablePriorityElection=" + this.enablePriorityElection + ", flushConfig=" + this.flush + "}";
    }

    public record FlushConfig(boolean enabled, Duration delayTime) {
        public FlushConfig(boolean enabled, Duration delayTime) {
            this.enabled = enabled;
            this.delayTime = Objects.requireNonNull(delayTime, "must specify a valid delay");
        }
    }
}

