/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.configuration.backpressure;

import com.google.common.base.Preconditions;
import io.camunda.zeebe.broker.system.configuration.ConfigurationUtil;
import java.time.Duration;

public class AIMDCfg {
    private Duration requestTimeout = Duration.ofMillis(200L);
    private int initialLimit = 100;
    private int minLimit = 1;
    private int maxLimit = 1000;
    private double backoffRatio = 0.9;

    public Duration getRequestTimeout() {
        return this.requestTimeout;
    }

    public void setRequestTimeout(Duration requestTimeout) {
        Preconditions.checkArgument((!requestTimeout.isNegative() && !requestTimeout.isZero() ? 1 : 0) != 0, (String)"Expected requestTimeout to be > 0, but found %s", (Object)requestTimeout);
        this.requestTimeout = requestTimeout;
    }

    public int getInitialLimit() {
        return this.initialLimit;
    }

    public void setInitialLimit(int initialLimit) {
        ConfigurationUtil.checkPositive(initialLimit, "initialLimit");
        this.initialLimit = initialLimit;
    }

    public int getMinLimit() {
        return this.minLimit;
    }

    public void setMinLimit(int minLimit) {
        ConfigurationUtil.checkPositive(minLimit, "minLimit");
        this.minLimit = minLimit;
    }

    public int getMaxLimit() {
        return this.maxLimit;
    }

    public void setMaxLimit(int maxLimit) {
        ConfigurationUtil.checkPositive(maxLimit, "maxLimit");
        this.maxLimit = maxLimit;
    }

    public double getBackoffRatio() {
        return this.backoffRatio;
    }

    public void setBackoffRatio(double backoffRatio) {
        Preconditions.checkArgument((backoffRatio < 1.0 && backoffRatio >= 0.5 ? 1 : 0) != 0, (String)"Expected backoff ratio to be in the range [0.5, 1.0), but found %s", (Object)backoffRatio);
        this.backoffRatio = backoffRatio;
    }

    public String toString() {
        return "AIMDCfg{requestTimeout='" + this.requestTimeout + ", initialLimit=" + this.initialLimit + ", minLimit=" + this.minLimit + ", maxLimit=" + this.maxLimit + ", backoffRatio=" + this.backoffRatio + "}";
    }
}

