/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.monitoring;

import io.camunda.zeebe.broker.Broker;
import io.camunda.zeebe.broker.system.configuration.DataCfg;
import io.camunda.zeebe.broker.system.configuration.DiskCfg;
import io.camunda.zeebe.broker.system.monitoring.DiskSpaceUsageListener;
import io.camunda.zeebe.broker.system.monitoring.DiskSpaceUsageMonitor;
import io.camunda.zeebe.scheduler.Actor;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.Duration;
import java.util.HashSet;
import java.util.Set;
import java.util.function.LongSupplier;

public class DiskSpaceUsageMonitorActor
extends Actor
implements DiskSpaceUsageMonitor {
    private final Set<DiskSpaceUsageListener> diskSpaceUsageListeners = new HashSet<DiskSpaceUsageListener>();
    private boolean currentDiskAvailableStatus = true;
    private LongSupplier freeDiskSpaceSupplier;
    private final Duration monitoringDelay;
    private final long minFreeDiskSpaceRequired;

    public DiskSpaceUsageMonitorActor(DataCfg dataCfg) {
        DiskCfg diskCfg = dataCfg.getDisk();
        this.monitoringDelay = diskCfg.getMonitoringInterval();
        File directory = new File(dataCfg.getDirectory());
        if (!directory.exists()) {
            throw new UncheckedIOException(new IOException("Folder '" + directory + "' does not exist."));
        }
        this.minFreeDiskSpaceRequired = diskCfg.getFreeSpace().getProcessing().toBytes();
        this.freeDiskSpaceSupplier = directory::getUsableSpace;
    }

    protected void onActorStarted() {
        this.checkDiskUsageAndNotifyListeners();
        this.actor.runAtFixedRate(this.monitoringDelay, this::checkDiskUsageAndNotifyListeners);
    }

    private void checkDiskUsageAndNotifyListeners() {
        long freeDiskSpaceAvailable = this.freeDiskSpaceSupplier.getAsLong();
        boolean previousStatus = this.currentDiskAvailableStatus;
        boolean bl = this.currentDiskAvailableStatus = freeDiskSpaceAvailable >= this.minFreeDiskSpaceRequired;
        if (this.currentDiskAvailableStatus != previousStatus) {
            if (!this.currentDiskAvailableStatus) {
                Broker.LOG.warn("Out of disk space. Current available {} bytes. Minimum needed {} bytes.", (Object)freeDiskSpaceAvailable, (Object)this.minFreeDiskSpaceRequired);
                this.diskSpaceUsageListeners.forEach(DiskSpaceUsageListener::onDiskSpaceNotAvailable);
            } else {
                Broker.LOG.info("Disk space available again. Current available {} bytes", (Object)freeDiskSpaceAvailable);
                this.diskSpaceUsageListeners.forEach(DiskSpaceUsageListener::onDiskSpaceAvailable);
            }
        }
    }

    @Override
    public void addDiskUsageListener(DiskSpaceUsageListener listener) {
        this.actor.call(() -> {
            this.diskSpaceUsageListeners.add(listener);
            if (!this.currentDiskAvailableStatus) {
                listener.onDiskSpaceNotAvailable();
            }
        });
    }

    @Override
    public void removeDiskUsageListener(DiskSpaceUsageListener listener) {
        this.actor.call(() -> this.diskSpaceUsageListeners.remove(listener));
    }

    @Override
    public void setFreeDiskSpaceSupplier(LongSupplier freeDiskSpaceSupplier) {
        this.freeDiskSpaceSupplier = freeDiskSpaceSupplier;
    }
}

