/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.transport.backupapi;

import io.camunda.zeebe.broker.transport.AsyncApiRequestHandler;
import io.camunda.zeebe.protocol.impl.encoding.BackupListResponse;
import io.camunda.zeebe.protocol.impl.encoding.BackupStatusResponse;
import io.camunda.zeebe.transport.ServerOutput;
import io.camunda.zeebe.transport.ServerResponse;
import io.camunda.zeebe.transport.impl.ServerResponseImpl;
import io.camunda.zeebe.util.buffer.BufferWriter;
import java.util.function.BiConsumer;
import java.util.function.IntSupplier;
import org.agrona.MutableDirectBuffer;

public final class BackupApiResponseWriter
implements AsyncApiRequestHandler.ResponseWriter {
    private final ServerResponseImpl response = new ServerResponseImpl();
    private boolean hasResponse = true;
    private BiConsumer<MutableDirectBuffer, Integer> responseWriter;
    private IntSupplier lengthSupplier;

    BackupApiResponseWriter withStatus(BackupStatusResponse response) {
        this.responseWriter = (arg_0, arg_1) -> ((BackupStatusResponse)response).write(arg_0, arg_1);
        this.lengthSupplier = () -> ((BackupStatusResponse)response).getLength();
        return this;
    }

    BackupApiResponseWriter withBackupList(BackupListResponse response) {
        this.responseWriter = (arg_0, arg_1) -> ((BackupListResponse)response).write(arg_0, arg_1);
        this.lengthSupplier = () -> ((BackupListResponse)response).getLength();
        return this;
    }

    BackupApiResponseWriter noResponse() {
        this.hasResponse = false;
        this.lengthSupplier = () -> 0;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tryWriteResponse(ServerOutput output, int partitionId, long requestId) {
        if (this.hasResponse) {
            try {
                this.response.reset().writer((BufferWriter)this).setPartitionId(partitionId).setRequestId(requestId);
                output.sendResponse((ServerResponse)this.response);
            }
            finally {
                this.reset();
            }
        }
    }

    @Override
    public void reset() {
        this.response.reset();
        this.hasResponse = true;
    }

    public int getLength() {
        return this.lengthSupplier.getAsInt();
    }

    public void write(MutableDirectBuffer buffer, int offset) {
        this.responseWriter.accept(buffer, offset);
    }
}

