/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.management;

import io.atomix.raft.RaftServer;
import io.camunda.zeebe.broker.exporter.stream.ExporterPhase;
import io.camunda.zeebe.stream.impl.StreamProcessor;

public final class PartitionStatus {
    private final RaftServer.Role role;
    private final String snapshotId;
    private final Long processedPosition;
    private final Long processedPositionInSnapshot;
    private final StreamProcessor.Phase streamProcessorPhase;
    private final ExporterPhase exporterPhase;
    private final Long exportedPosition;

    private PartitionStatus(RaftServer.Role role, Long processedPosition, String snapshotId, Long processedPositionInSnapshot, StreamProcessor.Phase streamProcessorPhase, ExporterPhase exporterPhase, Long exportedPosition) {
        this.role = role;
        this.processedPosition = processedPosition;
        this.snapshotId = snapshotId;
        this.processedPositionInSnapshot = processedPositionInSnapshot;
        this.streamProcessorPhase = streamProcessorPhase;
        this.exporterPhase = exporterPhase;
        this.exportedPosition = exportedPosition;
    }

    public static PartitionStatus ofLeader(Long processedPosition, String snapshotId, Long processedPositionInSnapshot, StreamProcessor.Phase streamProcessorPhase, ExporterPhase exporterPhase, long exportedPosition) {
        return new PartitionStatus(RaftServer.Role.LEADER, processedPosition, snapshotId, processedPositionInSnapshot, streamProcessorPhase, exporterPhase, exportedPosition);
    }

    public static PartitionStatus ofFollower(String snapshotId, Long processedPositionInSnapshot) {
        return new PartitionStatus(RaftServer.Role.FOLLOWER, null, snapshotId, processedPositionInSnapshot, null, null, null);
    }

    public RaftServer.Role getRole() {
        return this.role;
    }

    public Long getProcessedPosition() {
        return this.processedPosition;
    }

    public String getSnapshotId() {
        return this.snapshotId;
    }

    public Long getProcessedPositionInSnapshot() {
        return this.processedPositionInSnapshot;
    }

    public StreamProcessor.Phase getStreamProcessorPhase() {
        return this.streamProcessorPhase;
    }

    public ExporterPhase getExporterPhase() {
        return this.exporterPhase;
    }

    public Long getExportedPosition() {
        return this.exportedPosition;
    }

    public String toString() {
        return "PartitionStatus{role=" + this.role + ", snapshotId='" + this.snapshotId + "', processedPosition=" + this.processedPosition + ", processedPositionInSnapshot=" + this.processedPositionInSnapshot + ", streamProcessorPhase=" + this.streamProcessorPhase + ", exporterPhase=" + this.exporterPhase + ", exportedPosition=" + this.exportedPosition + "}";
    }
}

