/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.transport.queryapi;

import io.camunda.zeebe.broker.Loggers;
import io.camunda.zeebe.broker.system.configuration.QueryApiCfg;
import io.camunda.zeebe.broker.transport.AsyncApiRequestHandler;
import io.camunda.zeebe.broker.transport.ErrorResponseWriter;
import io.camunda.zeebe.broker.transport.queryapi.QueryRequestReader;
import io.camunda.zeebe.broker.transport.queryapi.QueryResponseWriter;
import io.camunda.zeebe.engine.state.QueryService;
import io.camunda.zeebe.protocol.record.ErrorCode;
import io.camunda.zeebe.protocol.record.ExecuteQueryRequestDecoder;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.future.CompletableActorFuture;
import io.camunda.zeebe.util.Either;
import java.util.EnumSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.agrona.DirectBuffer;
import org.agrona.collections.Int2ObjectHashMap;

@Deprecated(forRemoval=true, since="1.2.0")
public final class QueryApiRequestHandler
extends AsyncApiRequestHandler<QueryRequestReader, QueryResponseWriter> {
    private static final Set<ValueType> ACCEPTED_VALUE_TYPES = EnumSet.of(ValueType.PROCESS, ValueType.PROCESS_INSTANCE, ValueType.JOB);
    private final Map<Integer, QueryService> queryServicePerPartition = new Int2ObjectHashMap();
    private final QueryApiCfg config;
    private final String actorName;

    public QueryApiRequestHandler(QueryApiCfg config, int nodeId) {
        super(QueryRequestReader::new, QueryResponseWriter::new);
        this.config = config;
        this.actorName = QueryApiRequestHandler.buildActorName((int)nodeId, (String)"QueryApi");
    }

    public String getName() {
        return this.actorName;
    }

    protected void onActorClosing() {
        this.queryServicePerPartition.clear();
    }

    public void addPartition(int partitionId, QueryService queryService) {
        this.actor.run(() -> this.queryServicePerPartition.put(partitionId, queryService));
    }

    public void removePartition(int partitionId) {
        this.actor.run(() -> this.queryServicePerPartition.remove(partitionId));
    }

    @Override
    protected ActorFuture<Either<ErrorResponseWriter, QueryResponseWriter>> handleAsync(int partitionId, long requestId, QueryRequestReader requestReader, QueryResponseWriter responseWriter, ErrorResponseWriter errorWriter) {
        return CompletableActorFuture.completed(this.handle(partitionId, requestReader, responseWriter, errorWriter));
    }

    private Either<ErrorResponseWriter, QueryResponseWriter> handle(int partitionId, QueryRequestReader requestReader, QueryResponseWriter responseWriter, ErrorResponseWriter errorWriter) {
        if (!this.config.isEnabled()) {
            errorWriter.errorCode(ErrorCode.UNSUPPORTED_MESSAGE).errorMessage("Failed to handle query as the query API is disabled; did you configure zeebe.broker.experimental.queryapi.enabled?");
            return Either.left((Object)errorWriter);
        }
        QueryService queryService = this.queryServicePerPartition.get(partitionId);
        if (queryService == null) {
            errorWriter.partitionLeaderMismatch(partitionId);
            return Either.left((Object)errorWriter);
        }
        try {
            return this.handleQuery(this.queryServicePerPartition.get(partitionId), requestReader.getMessageDecoder(), responseWriter, errorWriter);
        }
        catch (QueryService.ClosedServiceException e) {
            Loggers.TRANSPORT_LOGGER.debug("Failed to handle query on partition {} as the query service was closed concurrently", (Object)partitionId, (Object)e);
            errorWriter.partitionLeaderMismatch(partitionId);
            return Either.left((Object)errorWriter);
        }
    }

    private Either<ErrorResponseWriter, QueryResponseWriter> handleQuery(QueryService queryService, ExecuteQueryRequestDecoder messageDecoder, QueryResponseWriter responseWriter, ErrorResponseWriter errorResponseWriter) {
        Optional bpmnProcessId;
        long key = messageDecoder.key();
        switch (messageDecoder.valueType()) {
            case PROCESS: {
                bpmnProcessId = queryService.getBpmnProcessIdForProcess(key);
                break;
            }
            case PROCESS_INSTANCE: {
                bpmnProcessId = queryService.getBpmnProcessIdForProcessInstance(key);
                break;
            }
            case JOB: {
                bpmnProcessId = queryService.getBpmnProcessIdForJob(key);
                break;
            }
            default: {
                return Either.left((Object)this.failOnInvalidValueType(messageDecoder, errorResponseWriter));
            }
        }
        if (bpmnProcessId.isEmpty()) {
            return Either.left((Object)this.failOnResourceNotFound(key, messageDecoder, errorResponseWriter));
        }
        responseWriter.bpmnProcessId((DirectBuffer)bpmnProcessId.get());
        return Either.right((Object)responseWriter);
    }

    private ErrorResponseWriter failOnResourceNotFound(long key, ExecuteQueryRequestDecoder messageDecoder, ErrorResponseWriter errorWriter) {
        return errorWriter.errorCode(ErrorCode.PROCESS_NOT_FOUND).errorMessage("Expected to find the process ID for resource of type %s with key %d, but no such resource was found", messageDecoder.valueType(), key);
    }

    private ErrorResponseWriter failOnInvalidValueType(ExecuteQueryRequestDecoder messageDecoder, ErrorResponseWriter errorWriter) {
        return errorWriter.internalError("Expected to handle query with value type of %s, but was %s", ACCEPTED_VALUE_TYPES, messageDecoder.valueType());
    }
}

