/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker;

import io.camunda.zeebe.broker.system.management.BrokerAdminService;
import io.camunda.zeebe.broker.system.monitoring.BrokerHealthCheckService;
import io.camunda.zeebe.gateway.impl.broker.BrokerClient;
import java.util.Optional;
import java.util.function.Supplier;
import org.springframework.stereotype.Component;

@Component
public class SpringBrokerBridge {
    private Supplier<BrokerHealthCheckService> healthCheckServiceSupplier;
    private Supplier<BrokerAdminService> adminServiceSupplier;
    private Supplier<BrokerClient> brokerClient;

    public void registerBrokerHealthCheckServiceSupplier(Supplier<BrokerHealthCheckService> healthCheckServiceSupplier) {
        this.healthCheckServiceSupplier = healthCheckServiceSupplier;
    }

    public Optional<BrokerHealthCheckService> getBrokerHealthCheckService() {
        return Optional.ofNullable(this.healthCheckServiceSupplier).map(Supplier::get);
    }

    public void registerBrokerAdminServiceSupplier(Supplier<BrokerAdminService> adminServiceSupplier) {
        this.adminServiceSupplier = adminServiceSupplier;
    }

    public Optional<BrokerAdminService> getAdminService() {
        return Optional.ofNullable(this.adminServiceSupplier).map(Supplier::get);
    }

    public void registerBrokerClient(Supplier<BrokerClient> brokerClient) {
        this.brokerClient = brokerClient;
    }

    public Optional<BrokerClient> getBrokerClient() {
        return Optional.ofNullable(this.brokerClient).map(Supplier::get);
    }
}

