/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.bootstrap;

import io.camunda.zeebe.broker.bootstrap.AbstractBrokerStartupStep;
import io.camunda.zeebe.broker.bootstrap.BrokerStartupContext;
import io.camunda.zeebe.broker.system.management.BrokerAdminServiceImpl;
import io.camunda.zeebe.scheduler.Actor;
import io.camunda.zeebe.scheduler.ConcurrencyControl;
import io.camunda.zeebe.scheduler.future.ActorFuture;

final class BrokerAdminServiceStep
extends AbstractBrokerStartupStep {
    BrokerAdminServiceStep() {
    }

    public String getName() {
        return "Broker Admin Interface";
    }

    @Override
    void startupInternal(BrokerStartupContext brokerStartupContext, ConcurrencyControl concurrencyControl, ActorFuture<BrokerStartupContext> startupFuture) {
        BrokerAdminServiceImpl adminService = new BrokerAdminServiceImpl();
        ActorFuture submitActorFuture = brokerStartupContext.getActorSchedulingService().submitActor((Actor)adminService);
        concurrencyControl.runOnCompletion(submitActorFuture, (ok, error) -> {
            if (error != null) {
                startupFuture.complete((Object)brokerStartupContext);
                return;
            }
            this.forwardExceptions(() -> {
                brokerStartupContext.getSpringBrokerBridge().registerBrokerAdminServiceSupplier(() -> adminService);
                brokerStartupContext.setBrokerAdminService(adminService);
                startupFuture.complete((Object)brokerStartupContext);
            }, startupFuture);
        });
    }

    @Override
    void shutdownInternal(BrokerStartupContext brokerShutdownContext, ConcurrencyControl concurrencyControl, ActorFuture<BrokerStartupContext> shutdownFuture) {
        BrokerAdminServiceImpl adminService = brokerShutdownContext.getBrokerAdminService();
        if (adminService == null) {
            shutdownFuture.complete((Object)brokerShutdownContext);
            return;
        }
        ActorFuture closeFuture = adminService.closeAsync();
        concurrencyControl.runOnCompletion(closeFuture, (ok, error) -> {
            if (error != null) {
                shutdownFuture.completeExceptionally(error);
                return;
            }
            this.forwardExceptions(() -> {
                brokerShutdownContext.setBrokerAdminService(null);
                shutdownFuture.complete((Object)brokerShutdownContext);
            }, shutdownFuture);
        });
    }
}

