/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.configuration;

import io.atomix.cluster.messaging.MessagingConfig;
import io.camunda.zeebe.broker.Broker;
import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.broker.system.configuration.ConfigurationEntry;
import io.camunda.zeebe.broker.system.configuration.MembershipCfg;
import io.camunda.zeebe.broker.system.configuration.RaftCfg;
import io.camunda.zeebe.util.StringUtil;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public final class ClusterCfg
implements ConfigurationEntry {
    public static final List<String> DEFAULT_CONTACT_POINTS = Collections.emptyList();
    public static final int DEFAULT_NODE_ID = 0;
    public static final int DEFAULT_PARTITIONS_COUNT = 1;
    public static final int DEFAULT_REPLICATION_FACTOR = 1;
    public static final int DEFAULT_CLUSTER_SIZE = 1;
    public static final String DEFAULT_CLUSTER_NAME = "zeebe-cluster";
    private static final String NODE_ID_ERROR_MSG = "Node id %s needs to be non negative and smaller then cluster size %s.";
    private static final String REPLICATION_FACTOR_ERROR_MSG = "Replication factor %s needs to be larger then zero and not larger then cluster size %s.";
    private static final String REPLICATION_FACTOR_WARN_MSG = "Expected to have odd replication factor, but was even ({}). Even replication factor has no benefit over the previous odd value and is weaker than next odd. Quorum is calculated as: quorum = floor(replication factor / 2) + 1. In this current case the quorum will be quorum = {}. If you want to ensure high fault-tolerance and availability, make sure to use an odd replication factor.";
    private static final Duration DEFAULT_HEARTBEAT_INTERVAL = Duration.ofMillis(250L);
    private static final Duration DEFAULT_ELECTION_TIMEOUT = Duration.ofMillis(2500L);
    private List<String> initialContactPoints = DEFAULT_CONTACT_POINTS;
    private List<Integer> partitionIds;
    private int nodeId = 0;
    private int partitionsCount = 1;
    private int replicationFactor = 1;
    private int clusterSize = 1;
    private String clusterName = "zeebe-cluster";
    private Duration heartbeatInterval = DEFAULT_HEARTBEAT_INTERVAL;
    private Duration electionTimeout = DEFAULT_ELECTION_TIMEOUT;
    private MembershipCfg membership = new MembershipCfg();
    private RaftCfg raft = new RaftCfg();
    private MessagingConfig.CompressionAlgorithm messageCompression = MessagingConfig.CompressionAlgorithm.NONE;

    @Override
    public void init(BrokerCfg globalConfig, String brokerBase) {
        this.initPartitionIds();
        if (this.partitionsCount < 1) {
            throw new IllegalArgumentException("Partition count must not be smaller then 1.");
        }
        if (this.nodeId < 0 || this.nodeId >= this.clusterSize) {
            throw new IllegalArgumentException(String.format(NODE_ID_ERROR_MSG, this.nodeId, this.clusterSize));
        }
        if (this.replicationFactor < 1 || this.replicationFactor > this.clusterSize) {
            throw new IllegalArgumentException(String.format(REPLICATION_FACTOR_ERROR_MSG, this.replicationFactor, this.clusterSize));
        }
        if (this.replicationFactor % 2 == 0) {
            Broker.LOG.warn(REPLICATION_FACTOR_WARN_MSG, (Object)this.replicationFactor, (Object)(this.replicationFactor / 2 + 1));
        }
        if (this.heartbeatInterval.toMillis() < 1L) {
            throw new IllegalArgumentException(String.format("heartbeatInterval %s must be at least 1ms", this.heartbeatInterval));
        }
        if (this.electionTimeout.toMillis() < 1L) {
            throw new IllegalArgumentException(String.format("electionTimeout %s must be at least 1ms", this.electionTimeout));
        }
        if (this.electionTimeout.compareTo(this.heartbeatInterval) < 1) {
            throw new IllegalArgumentException(String.format("electionTimeout %s must be greater than heartbeatInterval %s", this.electionTimeout, this.heartbeatInterval));
        }
    }

    private void initPartitionIds() {
        this.partitionIds = IntStream.range(1, 1 + this.partitionsCount).boxed().collect(Collectors.toList());
    }

    public List<String> getInitialContactPoints() {
        return this.initialContactPoints;
    }

    public void setInitialContactPoints(List<String> initialContactPoints) {
        this.initialContactPoints = (List)StringUtil.LIST_SANITIZER.apply(initialContactPoints);
    }

    public int getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(int nodeId) {
        this.nodeId = nodeId;
    }

    public int getPartitionsCount() {
        return this.partitionsCount;
    }

    public void setPartitionsCount(int partitionsCount) {
        this.partitionsCount = partitionsCount;
    }

    public List<Integer> getPartitionIds() {
        return this.partitionIds;
    }

    public int getReplicationFactor() {
        return this.replicationFactor;
    }

    public void setReplicationFactor(int replicationFactor) {
        this.replicationFactor = replicationFactor;
    }

    public int getClusterSize() {
        return this.clusterSize;
    }

    public void setClusterSize(int clusterSize) {
        this.clusterSize = clusterSize;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public MembershipCfg getMembership() {
        return this.membership;
    }

    public void setMembership(MembershipCfg membership) {
        this.membership = membership;
    }

    public Duration getHeartbeatInterval() {
        return this.heartbeatInterval;
    }

    public void setHeartbeatInterval(Duration heartbeatInterval) {
        this.heartbeatInterval = heartbeatInterval;
    }

    public RaftCfg getRaft() {
        return this.raft;
    }

    public void setRaft(RaftCfg raft) {
        this.raft = raft;
    }

    public Duration getElectionTimeout() {
        return this.electionTimeout;
    }

    public void setElectionTimeout(Duration electionTimeout) {
        this.electionTimeout = electionTimeout;
    }

    public MessagingConfig.CompressionAlgorithm getMessageCompression() {
        return this.messageCompression;
    }

    public void setMessageCompression(MessagingConfig.CompressionAlgorithm messageCompression) {
        this.messageCompression = messageCompression;
    }

    public String toString() {
        return "ClusterCfg{initialContactPoints=" + this.initialContactPoints + ", partitionIds=" + this.partitionIds + ", nodeId=" + this.nodeId + ", partitionsCount=" + this.partitionsCount + ", replicationFactor=" + this.replicationFactor + ", clusterSize=" + this.clusterSize + ", clusterName='" + this.clusterName + "', heartbeatInterval=" + this.heartbeatInterval + ", electionTimeout=" + this.electionTimeout + ", membership=" + this.membership + ", raft=" + this.raft + ", messageCompression=" + this.messageCompression + "}";
    }
}

