/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.exporter.repo;

import io.camunda.zeebe.broker.Loggers;
import io.camunda.zeebe.broker.exporter.context.ExporterContext;
import io.camunda.zeebe.broker.exporter.repo.ExporterDescriptor;
import io.camunda.zeebe.broker.exporter.repo.ExporterLoadException;
import io.camunda.zeebe.broker.system.configuration.ExporterCfg;
import io.camunda.zeebe.exporter.api.Exporter;
import io.camunda.zeebe.exporter.api.context.Context;
import io.camunda.zeebe.util.jar.ExternalJarLoadException;
import io.camunda.zeebe.util.jar.ExternalJarRepository;
import io.camunda.zeebe.util.jar.ThreadContextUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;

public final class ExporterRepository {
    private static final Logger LOG = Loggers.EXPORTER_LOGGER;
    private final ExternalJarRepository jarRepository;
    private final Map<String, ExporterDescriptor> exporters;

    public ExporterRepository() {
        this(new HashMap<String, ExporterDescriptor>(), new ExternalJarRepository());
    }

    public ExporterRepository(Map<String, ExporterDescriptor> exporters, ExternalJarRepository jarRepository) {
        this.exporters = exporters;
        this.jarRepository = jarRepository;
    }

    public Map<String, ExporterDescriptor> getExporters() {
        return Collections.unmodifiableMap(this.exporters);
    }

    public ExporterDescriptor load(String id, Class<? extends Exporter> exporterClass) throws ExporterLoadException {
        return this.load(id, exporterClass, null);
    }

    public ExporterDescriptor load(String id, Class<? extends Exporter> exporterClass, Map<String, Object> args) throws ExporterLoadException {
        ExporterDescriptor descriptor = this.exporters.get(id);
        if (descriptor == null) {
            descriptor = new ExporterDescriptor(id, exporterClass, args);
            this.validate(descriptor);
            this.exporters.put(id, descriptor);
        }
        return descriptor;
    }

    public ExporterDescriptor load(String id, ExporterCfg config) throws ExporterLoadException, ExternalJarLoadException {
        Class<Exporter> exporterClass;
        if (this.exporters.containsKey(id)) {
            return this.exporters.get(id);
        }
        ClassLoader classLoader = !config.isExternal() ? this.getClass().getClassLoader() : this.jarRepository.load(config.getJarPath());
        try {
            Class<?> specifiedClass = classLoader.loadClass(config.getClassName());
            exporterClass = specifiedClass.asSubclass(Exporter.class);
        }
        catch (ClassCastException | ClassNotFoundException e) {
            throw new ExporterLoadException(id, "cannot load specified class", e);
        }
        return this.load(id, exporterClass, config.getArgs());
    }

    private void validate(ExporterDescriptor descriptor) throws ExporterLoadException {
        try {
            Exporter instance = descriptor.newInstance();
            ExporterContext context = new ExporterContext(LOG, descriptor.getConfiguration());
            ThreadContextUtil.runCheckedWithClassLoader(() -> instance.configure((Context)context), (ClassLoader)instance.getClass().getClassLoader());
        }
        catch (Exception ex) {
            throw new ExporterLoadException(descriptor.getId(), "failed validation", ex);
        }
    }
}

