/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.partitions.impl.steps;

import io.atomix.raft.RaftServer;
import io.camunda.zeebe.broker.exporter.repo.ExporterDescriptor;
import io.camunda.zeebe.broker.exporter.stream.ExporterDirector;
import io.camunda.zeebe.broker.exporter.stream.ExporterDirectorContext;
import io.camunda.zeebe.broker.system.partitions.PartitionTransitionContext;
import io.camunda.zeebe.broker.system.partitions.PartitionTransitionStep;
import io.camunda.zeebe.scheduler.Actor;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.future.CompletableActorFuture;
import io.camunda.zeebe.util.health.HealthMonitorable;
import java.util.Collection;

public final class ExporterDirectorPartitionTransitionStep
implements PartitionTransitionStep {
    private static final int EXPORTER_PROCESSOR_ID = 1003;

    @Override
    public void onNewRaftRole(PartitionTransitionContext context, RaftServer.Role newRole) {
        ExporterDirector director = context.getExporterDirector();
        if (director != null && this.shouldCloseOnTransition(newRole, context.getCurrentRole())) {
            director.pauseExporting();
        }
    }

    @Override
    public ActorFuture<Void> prepareTransition(PartitionTransitionContext context, long term, RaftServer.Role targetRole) {
        ExporterDirector director = context.getExporterDirector();
        if (director != null && this.shouldCloseOnTransition(targetRole, context.getCurrentRole())) {
            context.getComponentHealthMonitor().removeComponent(director.getName());
            ActorFuture future = director.closeAsync();
            future.onComplete((success, error) -> {
                if (error == null) {
                    context.setExporterDirector(null);
                }
            });
            return future;
        }
        return CompletableActorFuture.completed(null);
    }

    @Override
    public ActorFuture<Void> transitionTo(PartitionTransitionContext context, long term, RaftServer.Role targetRole) {
        if (this.shouldInstallOnTransition(targetRole, context.getCurrentRole()) || context.getExporterDirector() == null && targetRole != RaftServer.Role.INACTIVE) {
            return this.openExporter(context, targetRole);
        }
        return CompletableActorFuture.completed(null);
    }

    @Override
    public String getName() {
        return "ExporterDirector";
    }

    private boolean shouldInstallOnTransition(RaftServer.Role newRole, RaftServer.Role currentRole) {
        return newRole == RaftServer.Role.LEADER || newRole == RaftServer.Role.FOLLOWER && currentRole != RaftServer.Role.CANDIDATE || newRole == RaftServer.Role.CANDIDATE && currentRole != RaftServer.Role.FOLLOWER;
    }

    private boolean shouldCloseOnTransition(RaftServer.Role newRole, RaftServer.Role currentRole) {
        return this.shouldInstallOnTransition(newRole, currentRole) || newRole == RaftServer.Role.INACTIVE;
    }

    private ActorFuture<Void> openExporter(PartitionTransitionContext context, RaftServer.Role targetRole) {
        Collection<ExporterDescriptor> exporterDescriptors = context.getExportedDescriptors();
        ExporterDirectorContext.ExporterMode exporterMode = targetRole == RaftServer.Role.LEADER ? ExporterDirectorContext.ExporterMode.ACTIVE : ExporterDirectorContext.ExporterMode.PASSIVE;
        ExporterDirectorContext exporterCtx = new ExporterDirectorContext().id(1003).name(Actor.buildActorName((String)"Exporter", (int)context.getPartitionId())).logStream(context.getLogStream()).zeebeDb(context.getZeebeDb()).partitionMessagingService(context.getMessagingService()).descriptors(exporterDescriptors).exporterMode(exporterMode);
        ExporterDirector director = new ExporterDirector(exporterCtx, !context.shouldExport());
        context.getComponentHealthMonitor().registerComponent(director.getName(), (HealthMonitorable)director);
        ActorFuture<Void> startFuture = director.startAsync(context.getActorSchedulingService());
        startFuture.onComplete((nothing, error) -> {
            if (error == null) {
                context.setExporterDirector(director);
                if (!context.shouldExport()) {
                    director.pauseExporting();
                } else {
                    director.resumeExporting();
                }
            }
        });
        return startFuture;
    }
}

