/* Generated SBE (Simple Binary Encoding) message codec. */
package io.camunda.zeebe.broker.protocol;

import org.agrona.MutableDirectBuffer;
import org.agrona.DirectBuffer;
import org.agrona.sbe.*;

@SuppressWarnings("all")
public final class InterPartitionMessageEncoder implements MessageEncoderFlyweight
{
    public static final int BLOCK_LENGTH = 20;
    public static final int TEMPLATE_ID = 4;
    public static final int SCHEMA_ID = 5;
    public static final int SCHEMA_VERSION = 3;
    public static final String SEMANTIC_VERSION = "0.1.0";
    public static final java.nio.ByteOrder BYTE_ORDER = java.nio.ByteOrder.LITTLE_ENDIAN;

    private final InterPartitionMessageEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;

    public int sbeBlockLength()
    {
        return BLOCK_LENGTH;
    }

    public int sbeTemplateId()
    {
        return TEMPLATE_ID;
    }

    public int sbeSchemaId()
    {
        return SCHEMA_ID;
    }

    public int sbeSchemaVersion()
    {
        return SCHEMA_VERSION;
    }

    public String sbeSemanticType()
    {
        return "";
    }

    public MutableDirectBuffer buffer()
    {
        return buffer;
    }

    public int initialOffset()
    {
        return initialOffset;
    }

    public int offset()
    {
        return offset;
    }

    public InterPartitionMessageEncoder wrap(final MutableDirectBuffer buffer, final int offset)
    {
        if (buffer != this.buffer)
        {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        limit(offset + BLOCK_LENGTH);

        return this;
    }

    public InterPartitionMessageEncoder wrapAndApplyHeader(
        final MutableDirectBuffer buffer, final int offset, final MessageHeaderEncoder headerEncoder)
    {
        headerEncoder
            .wrap(buffer, offset)
            .blockLength(BLOCK_LENGTH)
            .templateId(TEMPLATE_ID)
            .schemaId(SCHEMA_ID)
            .version(SCHEMA_VERSION);

        return wrap(buffer, offset + MessageHeaderEncoder.ENCODED_LENGTH);
    }

    public int encodedLength()
    {
        return limit - offset;
    }

    public int limit()
    {
        return limit;
    }

    public void limit(final int limit)
    {
        this.limit = limit;
    }

    public static int receiverPartitionIdId()
    {
        return 0;
    }

    public static int receiverPartitionIdSinceVersion()
    {
        return 0;
    }

    public static int receiverPartitionIdEncodingOffset()
    {
        return 0;
    }

    public static int receiverPartitionIdEncodingLength()
    {
        return 2;
    }

    public static String receiverPartitionIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int receiverPartitionIdNullValue()
    {
        return 65535;
    }

    public static int receiverPartitionIdMinValue()
    {
        return 0;
    }

    public static int receiverPartitionIdMaxValue()
    {
        return 65534;
    }

    public InterPartitionMessageEncoder receiverPartitionId(final int value)
    {
        buffer.putShort(offset + 0, (short)value, java.nio.ByteOrder.LITTLE_ENDIAN);
        return this;
    }


    public static int valueTypeId()
    {
        return 1;
    }

    public static int valueTypeSinceVersion()
    {
        return 0;
    }

    public static int valueTypeEncodingOffset()
    {
        return 2;
    }

    public static int valueTypeEncodingLength()
    {
        return 1;
    }

    public static String valueTypeMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static short valueTypeNullValue()
    {
        return (short)255;
    }

    public static short valueTypeMinValue()
    {
        return (short)0;
    }

    public static short valueTypeMaxValue()
    {
        return (short)254;
    }

    public InterPartitionMessageEncoder valueType(final short value)
    {
        buffer.putByte(offset + 2, (byte)value);
        return this;
    }


    public static int intentId()
    {
        return 2;
    }

    public static int intentSinceVersion()
    {
        return 0;
    }

    public static int intentEncodingOffset()
    {
        return 3;
    }

    public static int intentEncodingLength()
    {
        return 1;
    }

    public static String intentMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static short intentNullValue()
    {
        return (short)255;
    }

    public static short intentMinValue()
    {
        return (short)0;
    }

    public static short intentMaxValue()
    {
        return (short)254;
    }

    public InterPartitionMessageEncoder intent(final short value)
    {
        buffer.putByte(offset + 3, (byte)value);
        return this;
    }


    public static int recordKeyId()
    {
        return 3;
    }

    public static int recordKeySinceVersion()
    {
        return 0;
    }

    public static int recordKeyEncodingOffset()
    {
        return 4;
    }

    public static int recordKeyEncodingLength()
    {
        return 8;
    }

    public static String recordKeyMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "optional";
        }

        return "";
    }

    public static long recordKeyNullValue()
    {
        return 0xffffffffffffffffL;
    }

    public static long recordKeyMinValue()
    {
        return 0x0L;
    }

    public static long recordKeyMaxValue()
    {
        return 0xfffffffffffffffeL;
    }

    public InterPartitionMessageEncoder recordKey(final long value)
    {
        buffer.putLong(offset + 4, value, java.nio.ByteOrder.LITTLE_ENDIAN);
        return this;
    }


    public static int checkpointIdId()
    {
        return 4;
    }

    public static int checkpointIdSinceVersion()
    {
        return 0;
    }

    public static int checkpointIdEncodingOffset()
    {
        return 12;
    }

    public static int checkpointIdEncodingLength()
    {
        return 8;
    }

    public static String checkpointIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long checkpointIdNullValue()
    {
        return -9223372036854775808L;
    }

    public static long checkpointIdMinValue()
    {
        return -9223372036854775807L;
    }

    public static long checkpointIdMaxValue()
    {
        return 9223372036854775807L;
    }

    public InterPartitionMessageEncoder checkpointId(final long value)
    {
        buffer.putLong(offset + 12, value, java.nio.ByteOrder.LITTLE_ENDIAN);
        return this;
    }


    public static int commandId()
    {
        return 32;
    }

    public static String commandCharacterEncoding()
    {
        return java.nio.charset.StandardCharsets.UTF_8.name();
    }

    public static String commandMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int commandHeaderLength()
    {
        return 4;
    }

    public InterPartitionMessageEncoder putCommand(final DirectBuffer src, final int srcOffset, final int length)
    {
        if (length > 2147483647)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
        buffer.putBytes(limit + headerLength, src, srcOffset, length);

        return this;
    }

    public InterPartitionMessageEncoder putCommand(final byte[] src, final int srcOffset, final int length)
    {
        if (length > 2147483647)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
        buffer.putBytes(limit + headerLength, src, srcOffset, length);

        return this;
    }

    public InterPartitionMessageEncoder command(final String value)
    {
        final byte[] bytes = (null == value || value.isEmpty()) ? org.agrona.collections.ArrayUtil.EMPTY_BYTE_ARRAY : value.getBytes(java.nio.charset.StandardCharsets.UTF_8);

        final int length = bytes.length;
        if (length > 2147483647)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
        buffer.putBytes(limit + headerLength, bytes, 0, length);

        return this;
    }

    public String toString()
    {
        if (null == buffer)
        {
            return "";
        }

        return appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(final StringBuilder builder)
    {
        if (null == buffer)
        {
            return builder;
        }

        final InterPartitionMessageDecoder decoder = new InterPartitionMessageDecoder();
        decoder.wrap(buffer, initialOffset, BLOCK_LENGTH, SCHEMA_VERSION);

        return decoder.appendTo(builder);
    }
}
