/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.logstreams;

import io.camunda.zeebe.broker.Loggers;
import io.camunda.zeebe.broker.logstreams.LogCompactor;
import io.camunda.zeebe.scheduler.Actor;
import io.camunda.zeebe.snapshots.PersistedSnapshot;
import io.camunda.zeebe.snapshots.PersistedSnapshotListener;
import io.camunda.zeebe.snapshots.PersistedSnapshotStore;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

public final class LogDeletionService
extends Actor
implements PersistedSnapshotListener {
    private final LogCompactor logCompactor;
    private final String actorName;
    private final PersistedSnapshotStore persistedSnapshotStore;
    private final int partitionId;

    public LogDeletionService(int nodeId, int partitionId, LogCompactor logCompactor, PersistedSnapshotStore persistedSnapshotStore) {
        this.persistedSnapshotStore = persistedSnapshotStore;
        this.logCompactor = logCompactor;
        this.actorName = LogDeletionService.buildActorName((int)nodeId, (String)"DeletionService", (int)partitionId);
        this.partitionId = partitionId;
    }

    protected Map<String, String> createContext() {
        Map context = super.createContext();
        context.put("partitionId", Integer.toString(this.partitionId));
        return context;
    }

    public String getName() {
        return this.actorName;
    }

    protected void onActorStarting() {
        this.persistedSnapshotStore.addSnapshotListener((PersistedSnapshotListener)this);
    }

    protected void onActorClosing() {
        this.persistedSnapshotStore.removeSnapshotListener((PersistedSnapshotListener)this);
    }

    public void onNewSnapshot(PersistedSnapshot newPersistedSnapshot) {
        this.actor.run(() -> this.persistedSnapshotStore.getAvailableSnapshots().onComplete((availableSnapshots, error) -> {
            if (error == null) {
                this.delegateDeletion(this.getCompactionBoundOfOldestSnapshot((Set<PersistedSnapshot>)availableSnapshots));
            } else {
                Loggers.DELETION_SERVICE.error("Expected to compact logs, but could not get list of available snapshots.", error);
            }
        }));
    }

    private long getCompactionBoundOfOldestSnapshot(Set<PersistedSnapshot> availableSnapshots) {
        return availableSnapshots.stream().map(PersistedSnapshot::getCompactionBound).min(Long::compareTo).orElse(0L);
    }

    private void delegateDeletion(long compactionBound) {
        if (compactionBound <= 0L) {
            return;
        }
        ((CompletableFuture)this.logCompactor.compactLog(compactionBound).exceptionally(error -> this.logCompactionError(compactionBound, (Throwable)error))).join();
    }

    private Void logCompactionError(long compactionBound, Throwable error) {
        if (error != null) {
            Loggers.DELETION_SERVICE.error("Failed to compact Atomix log up to index {}", (Object)compactionBound, (Object)error);
        }
        return null;
    }
}

