/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.logstreams;

import io.atomix.raft.storage.log.IndexedRaftLogEntry;
import io.atomix.raft.storage.log.RaftLogReader;
import io.atomix.raft.storage.log.entry.SerializedApplicationEntry;
import io.camunda.zeebe.logstreams.storage.LogStorageReader;
import java.util.NoSuchElementException;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class AtomixLogStorageReader
implements LogStorageReader {
    private final RaftLogReader reader;
    private final DirectBuffer currentBlockBuffer;
    private final DirectBuffer nextBlockBuffer;

    public AtomixLogStorageReader(RaftLogReader reader) {
        this.reader = reader;
        this.currentBlockBuffer = new UnsafeBuffer();
        this.nextBlockBuffer = new UnsafeBuffer();
        this.reset();
    }

    public void seek(long position) {
        long boundedPosition = Math.max(0L, position);
        this.reader.seekToAsqn(boundedPosition);
        this.reset();
        this.readNextBlock();
    }

    public void close() {
        this.reset();
        this.reader.close();
    }

    public boolean hasNext() {
        return this.hasNextBlock() || this.readNextBlock();
    }

    public DirectBuffer next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.currentBlockBuffer.wrap(this.nextBlockBuffer);
        this.nextBlockBuffer.wrap(0L, 0);
        return this.currentBlockBuffer;
    }

    private boolean hasNextBlock() {
        return this.nextBlockBuffer.addressOffset() != 0L;
    }

    private boolean readNextBlock() {
        while (this.reader.hasNext()) {
            IndexedRaftLogEntry entry = (IndexedRaftLogEntry)this.reader.next();
            if (!entry.isApplicationEntry()) continue;
            SerializedApplicationEntry nextEntry = (SerializedApplicationEntry)entry.getApplicationEntry();
            this.nextBlockBuffer.wrap(nextEntry.data());
            return true;
        }
        return false;
    }

    private void reset() {
        this.currentBlockBuffer.wrap(0L, 0);
        this.nextBlockBuffer.wrap(0L, 0);
    }
}

