/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.bootstrap;

import io.camunda.zeebe.broker.bootstrap.AbstractBrokerStartupStep;
import io.camunda.zeebe.broker.bootstrap.BrokerStartupContext;
import io.camunda.zeebe.broker.partitioning.PartitionManagerImpl;
import io.camunda.zeebe.broker.system.management.BrokerAdminServiceImpl;
import io.camunda.zeebe.scheduler.ConcurrencyControl;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

final class PartitionManagerStep
extends AbstractBrokerStartupStep {
    PartitionManagerStep() {
    }

    public String getName() {
        return "Partition Manager";
    }

    @Override
    void startupInternal(BrokerStartupContext brokerStartupContext, ConcurrencyControl concurrencyControl, ActorFuture<BrokerStartupContext> startupFuture) {
        PartitionManagerImpl partitionManager = new PartitionManagerImpl(brokerStartupContext.getActorSchedulingService(), brokerStartupContext.getBrokerConfiguration(), brokerStartupContext.getBrokerInfo(), brokerStartupContext.getClusterServices(), brokerStartupContext.getHealthCheckService(), brokerStartupContext.getDiskSpaceUsageMonitor(), brokerStartupContext.getPartitionListeners(), brokerStartupContext.getCommandApiService(), brokerStartupContext.getExporterRepository(), brokerStartupContext.getGatewayBrokerTransport(), brokerStartupContext.getJobStreamService().jobStreamer(), brokerStartupContext.getClusterTopology().getPartitionDistribution());
        ((CompletableFuture)CompletableFuture.supplyAsync(partitionManager::start).thenCompose(Function.identity())).whenComplete((ok, error) -> {
            if (error != null) {
                startupFuture.completeExceptionally(error);
                return;
            }
            this.forwardExceptions(() -> concurrencyControl.run(() -> this.forwardExceptions(() -> {
                BrokerAdminServiceImpl adminService = brokerStartupContext.getBrokerAdminService();
                adminService.injectAdminAccess(partitionManager.createAdminAccess((ConcurrencyControl)adminService));
                adminService.injectPartitionInfoSource(partitionManager.getZeebePartitions());
                brokerStartupContext.setPartitionManager(partitionManager);
                startupFuture.complete((Object)brokerStartupContext);
            }, startupFuture)), startupFuture);
        });
    }

    @Override
    void shutdownInternal(BrokerStartupContext brokerShutdownContext, ConcurrencyControl concurrencyControl, ActorFuture<BrokerStartupContext> shutdownFuture) {
        PartitionManagerImpl partitionManager = brokerShutdownContext.getPartitionManager();
        if (partitionManager == null) {
            shutdownFuture.complete(null);
            return;
        }
        ((CompletableFuture)CompletableFuture.supplyAsync(partitionManager::stop).thenCompose(Function.identity())).whenComplete((ok, error) -> {
            if (error != null) {
                shutdownFuture.completeExceptionally(error);
                return;
            }
            this.forwardExceptions(() -> concurrencyControl.run(() -> this.forwardExceptions(() -> {
                brokerShutdownContext.setPartitionManager(null);
                shutdownFuture.complete((Object)brokerShutdownContext);
            }, shutdownFuture)), shutdownFuture);
        });
    }
}

