/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.jobstream;

import io.camunda.zeebe.broker.PartitionListener;
import io.camunda.zeebe.broker.jobstream.JobStreamErrorHandler;
import io.camunda.zeebe.broker.jobstream.RemoteJobStreamErrorHandler;
import io.camunda.zeebe.engine.state.QueryService;
import io.camunda.zeebe.logstreams.log.LogStream;
import io.camunda.zeebe.logstreams.log.LogStreamWriter;
import io.camunda.zeebe.protocol.impl.stream.job.ActivatedJob;
import io.camunda.zeebe.scheduler.Actor;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.future.CompletableActorFuture;
import io.camunda.zeebe.transport.stream.api.RemoteStreamErrorHandler;
import java.util.Objects;

public final class RemoteJobStreamErrorHandlerService
extends Actor
implements PartitionListener,
RemoteStreamErrorHandler<ActivatedJob> {
    private final RemoteJobStreamErrorHandler delegate;
    private final String name;

    public RemoteJobStreamErrorHandlerService(JobStreamErrorHandler errorHandler) {
        this.delegate = new RemoteJobStreamErrorHandler(errorHandler);
        this.name = "RemoteJobStreamErrorHandler";
    }

    public String getName() {
        return this.name;
    }

    @Override
    public ActorFuture<Void> onBecomingFollower(int partitionId, long term) {
        return this.actor.call(() -> this.delegate.removeWriter(partitionId));
    }

    @Override
    public ActorFuture<Void> onBecomingLeader(int partitionId, long term, LogStream logStream, QueryService queryService) {
        CompletableActorFuture result = new CompletableActorFuture();
        ActorFuture onLogStreamWriter = Objects.requireNonNull(logStream, "must specify a log stream").newLogStreamWriter();
        this.actor.run(() -> this.actor.runOnCompletion(onLogStreamWriter, (writer, error) -> {
            if (error != null) {
                result.completeExceptionally(error);
                return;
            }
            this.delegate.addWriter(partitionId, (LogStreamWriter)writer);
            result.complete(null);
        }));
        return result;
    }

    @Override
    public ActorFuture<Void> onBecomingInactive(int partitionId, long term) {
        return this.actor.call(() -> this.delegate.removeWriter(partitionId));
    }

    public void handleError(Throwable error, ActivatedJob job) {
        this.actor.run(() -> this.delegate.handleError(error, job));
    }
}

