/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.partitioning;

import io.atomix.primitive.partition.PartitionManagementService;
import io.atomix.primitive.partition.PartitionMetadata;
import io.atomix.raft.partition.RaftPartition;
import io.camunda.zeebe.broker.partitioning.RaftPartitionFactory;
import io.camunda.zeebe.broker.partitioning.ZeebePartitionFactory;
import io.camunda.zeebe.broker.system.partitions.ZeebePartition;
import io.camunda.zeebe.scheduler.Actor;
import io.camunda.zeebe.scheduler.ActorSchedulingService;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class PartitionStartup {
    private final ActorSchedulingService schedulingService;
    private final PartitionManagementService partitionManagementService;
    private final RaftPartitionFactory raftPartitionFactory;
    private final ZeebePartitionFactory zeebePartitionFactory;

    PartitionStartup(ActorSchedulingService schedulingService, PartitionManagementService partitionManagementService, RaftPartitionFactory raftPartitionFactory, ZeebePartitionFactory zeebePartitionFactory) {
        this.schedulingService = schedulingService;
        this.partitionManagementService = partitionManagementService;
        this.raftPartitionFactory = raftPartitionFactory;
        this.zeebePartitionFactory = zeebePartitionFactory;
    }

    CompletableFuture<StartedPartition> bootstrap(PartitionMetadata partitionMetadata) {
        BootstrapActor bootstrap = new BootstrapActor(partitionMetadata);
        this.schedulingService.submitActor((Actor)bootstrap);
        return bootstrap.result();
    }

    final class BootstrapActor
    extends Actor {
        private static final Logger LOG = LoggerFactory.getLogger((String)"io.camunda.zeebe.broker.partitioning.bootstrap");
        private final CompletableFuture<StartedPartition> result = new CompletableFuture();
        private final PartitionMetadata partitionMetadata;
        private final String name;

        public BootstrapActor(PartitionMetadata partitionMetadata) {
            this.name = BootstrapActor.buildActorName((String)"Bootstrap", (int)((Integer)partitionMetadata.id().id()));
            this.partitionMetadata = partitionMetadata;
        }

        protected Map<String, String> createContext() {
            Map context = super.createContext();
            context.put("partitionId", Integer.toString((Integer)this.partitionMetadata.id().id()));
            return context;
        }

        public String getName() {
            return this.name;
        }

        protected void onActorStarted() {
            Integer partitionId = (Integer)this.partitionMetadata.id().id();
            RaftPartition raftPartition = PartitionStartup.this.raftPartitionFactory.createRaftPartition(this.partitionMetadata);
            ((CompletableFuture)((CompletableFuture)CompletableFuture.supplyAsync(() -> {
                LOG.debug("Starting raft partition {}", (Object)partitionId);
                return (RaftPartition)raftPartition.open(PartitionStartup.this.partitionManagementService).join();
            }).exceptionally(t -> {
                LOG.error("Failed to start raft partition {}", (Object)raftPartition.id(), t);
                raftPartition.close();
                this.result.completeExceptionally((Throwable)t);
                return null;
            })).thenAccept(startedRaftPartition -> this.actor.call(() -> this.startZeebePartition((RaftPartition)startedRaftPartition)))).exceptionally(t -> {
                LOG.error("Failed to start zeebe partition {}", (Object)partitionId, t);
                this.result.completeExceptionally((Throwable)t);
                return null;
            });
        }

        protected void handleFailure(Throwable failure) {
            this.result.completeExceptionally(failure);
            this.closeAsync();
        }

        private void startZeebePartition(RaftPartition startedRaftPartition) {
            ZeebePartition zeebePartition = PartitionStartup.this.zeebePartitionFactory.constructPartition(startedRaftPartition);
            this.runOnCompletion(PartitionStartup.this.schedulingService.submitActor((Actor)zeebePartition), (v, t) -> {
                if (t == null) {
                    LOG.debug("Zeebe partition started successfully");
                    this.result.complete(new StartedPartition(startedRaftPartition, zeebePartition));
                } else {
                    LOG.debug("Zeebe partition failed to start");
                    startedRaftPartition.close();
                    zeebePartition.closeAsync();
                    this.result.completeExceptionally((Throwable)t);
                }
                this.closeAsync();
            });
        }

        CompletableFuture<StartedPartition> result() {
            return this.result;
        }
    }

    record StartedPartition(RaftPartition raftPartition, ZeebePartition zeebePartition) {
    }
}

