/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.partitioning;

import io.atomix.cluster.ClusterMembershipService;
import io.atomix.cluster.messaging.ClusterCommunicationService;
import io.atomix.raft.partition.RaftPartition;
import io.camunda.zeebe.broker.PartitionListener;
import io.camunda.zeebe.broker.clustering.ClusterServices;
import io.camunda.zeebe.broker.exporter.repo.ExporterRepository;
import io.camunda.zeebe.broker.logstreams.state.StatePositionSupplier;
import io.camunda.zeebe.broker.partitioning.topology.TopologyManagerImpl;
import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.broker.system.configuration.ConsistencyCheckCfg;
import io.camunda.zeebe.broker.system.configuration.RocksdbCfg;
import io.camunda.zeebe.broker.system.monitoring.BrokerHealthCheckService;
import io.camunda.zeebe.broker.system.monitoring.DiskSpaceUsageMonitor;
import io.camunda.zeebe.broker.system.partitions.PartitionStartupAndTransitionContextImpl;
import io.camunda.zeebe.broker.system.partitions.PartitionStartupContext;
import io.camunda.zeebe.broker.system.partitions.PartitionTransitionStep;
import io.camunda.zeebe.broker.system.partitions.StateController;
import io.camunda.zeebe.broker.system.partitions.TypedRecordProcessorsFactory;
import io.camunda.zeebe.broker.system.partitions.ZeebePartition;
import io.camunda.zeebe.broker.system.partitions.impl.AtomixPartitionMessagingService;
import io.camunda.zeebe.broker.system.partitions.impl.AtomixRecordEntrySupplierImpl;
import io.camunda.zeebe.broker.system.partitions.impl.PartitionProcessingState;
import io.camunda.zeebe.broker.system.partitions.impl.PartitionTransitionImpl;
import io.camunda.zeebe.broker.system.partitions.impl.StateControllerImpl;
import io.camunda.zeebe.broker.system.partitions.impl.steps.AdminApiRequestHandlerStep;
import io.camunda.zeebe.broker.system.partitions.impl.steps.BackupApiRequestHandlerStep;
import io.camunda.zeebe.broker.system.partitions.impl.steps.BackupServiceTransitionStep;
import io.camunda.zeebe.broker.system.partitions.impl.steps.BackupStoreTransitionStep;
import io.camunda.zeebe.broker.system.partitions.impl.steps.ExporterDirectorPartitionTransitionStep;
import io.camunda.zeebe.broker.system.partitions.impl.steps.InterPartitionCommandServiceStep;
import io.camunda.zeebe.broker.system.partitions.impl.steps.LogStoragePartitionTransitionStep;
import io.camunda.zeebe.broker.system.partitions.impl.steps.LogStreamPartitionTransitionStep;
import io.camunda.zeebe.broker.system.partitions.impl.steps.QueryServicePartitionTransitionStep;
import io.camunda.zeebe.broker.system.partitions.impl.steps.RockDbMetricExporterPartitionStartupStep;
import io.camunda.zeebe.broker.system.partitions.impl.steps.SnapshotDirectorPartitionTransitionStep;
import io.camunda.zeebe.broker.system.partitions.impl.steps.StreamProcessorTransitionStep;
import io.camunda.zeebe.broker.system.partitions.impl.steps.ZeebeDbPartitionTransitionStep;
import io.camunda.zeebe.broker.transport.commandapi.CommandApiService;
import io.camunda.zeebe.db.ZeebeDbFactory;
import io.camunda.zeebe.db.impl.rocksdb.ZeebeRocksDbFactory;
import io.camunda.zeebe.engine.processing.EngineProcessors;
import io.camunda.zeebe.engine.processing.message.command.SubscriptionCommandSender;
import io.camunda.zeebe.engine.processing.streamprocessor.JobStreamer;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessorContext;
import io.camunda.zeebe.protocol.impl.encoding.BrokerInfo;
import io.camunda.zeebe.scheduler.ActorSchedulingService;
import io.camunda.zeebe.scheduler.ConcurrencyControl;
import io.camunda.zeebe.scheduler.startup.StartupStep;
import io.camunda.zeebe.snapshots.ConstructableSnapshotStore;
import io.camunda.zeebe.snapshots.PersistedSnapshotStore;
import io.camunda.zeebe.snapshots.impl.FileBasedSnapshotStoreFactory;
import io.camunda.zeebe.stream.api.InterPartitionCommandSender;
import io.camunda.zeebe.transport.impl.AtomixServerTransport;
import io.camunda.zeebe.util.FeatureFlags;
import io.camunda.zeebe.util.FileUtil;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;

final class ZeebePartitionFactory {
    private static final List<StartupStep<PartitionStartupContext>> STARTUP_STEPS = List.of(new RockDbMetricExporterPartitionStartupStep());
    private static final List<PartitionTransitionStep> TRANSITION_STEPS = List.of(new LogStoragePartitionTransitionStep(), new LogStreamPartitionTransitionStep(), new ZeebeDbPartitionTransitionStep(), new QueryServicePartitionTransitionStep(), new BackupStoreTransitionStep(), new BackupServiceTransitionStep(), new InterPartitionCommandServiceStep(), new StreamProcessorTransitionStep(), new SnapshotDirectorPartitionTransitionStep(), new ExporterDirectorPartitionTransitionStep(), new BackupApiRequestHandlerStep(), new AdminApiRequestHandlerStep());
    private final ActorSchedulingService actorSchedulingService;
    private final BrokerCfg brokerCfg;
    private final BrokerInfo localBroker;
    private final CommandApiService commandApiService;
    private final FileBasedSnapshotStoreFactory snapshotStoreFactory;
    private final ClusterServices clusterServices;
    private final ExporterRepository exporterRepository;
    private final BrokerHealthCheckService healthCheckService;
    private final DiskSpaceUsageMonitor diskSpaceUsageMonitor;
    private final AtomixServerTransport gatewayBrokerTransport;
    private final JobStreamer jobStreamer;
    private final List<PartitionListener> partitionListeners;
    private final TopologyManagerImpl topologyManager;
    private final FeatureFlags featureFlags;

    ZeebePartitionFactory(ActorSchedulingService actorSchedulingService, BrokerCfg brokerCfg, BrokerInfo localBroker, CommandApiService commandApiService, FileBasedSnapshotStoreFactory snapshotStoreFactory, ClusterServices clusterServices, ExporterRepository exporterRepository, BrokerHealthCheckService healthCheckService, DiskSpaceUsageMonitor diskSpaceUsageMonitor, AtomixServerTransport gatewayBrokerTransport, JobStreamer jobStreamer, List<PartitionListener> partitionListeners, TopologyManagerImpl topologyManager, FeatureFlags featureFlags) {
        this.actorSchedulingService = actorSchedulingService;
        this.brokerCfg = brokerCfg;
        this.localBroker = localBroker;
        this.commandApiService = commandApiService;
        this.snapshotStoreFactory = snapshotStoreFactory;
        this.clusterServices = clusterServices;
        this.exporterRepository = exporterRepository;
        this.healthCheckService = healthCheckService;
        this.diskSpaceUsageMonitor = diskSpaceUsageMonitor;
        this.gatewayBrokerTransport = gatewayBrokerTransport;
        this.jobStreamer = jobStreamer;
        this.partitionListeners = partitionListeners;
        this.topologyManager = topologyManager;
        this.featureFlags = featureFlags;
    }

    ZeebePartition constructPartition(RaftPartition raftPartition) {
        ClusterCommunicationService communicationService = this.clusterServices.getCommunicationService();
        ClusterMembershipService membershipService = this.clusterServices.getMembershipService();
        TypedRecordProcessorsFactory typedRecordProcessorsFactory = this.createFactory(this.localBroker, this.featureFlags);
        Integer partitionId = (Integer)raftPartition.id().id();
        ConstructableSnapshotStore constructableSnapshotStore = this.snapshotStoreFactory.getConstructableSnapshotStore(partitionId.intValue());
        StateController stateController = this.createStateController(raftPartition, constructableSnapshotStore, this.snapshotStoreFactory.getSnapshotStoreConcurrencyControl(partitionId.intValue()));
        PartitionStartupAndTransitionContextImpl context = new PartitionStartupAndTransitionContextImpl(this.localBroker.getNodeId(), communicationService, raftPartition, this.partitionListeners, new AtomixPartitionMessagingService(communicationService, membershipService, raftPartition.members()), this.actorSchedulingService, this.brokerCfg, this.commandApiService::newCommandResponseWriter, () -> this.commandApiService.getOnProcessedListener(partitionId), (PersistedSnapshotStore)constructableSnapshotStore, stateController, typedRecordProcessorsFactory, this.exporterRepository, new PartitionProcessingState(raftPartition), this.diskSpaceUsageMonitor, this.gatewayBrokerTransport, this.topologyManager);
        PartitionTransitionImpl newTransitionBehavior = new PartitionTransitionImpl(TRANSITION_STEPS);
        ZeebePartition zeebePartition = new ZeebePartition(context, newTransitionBehavior, STARTUP_STEPS);
        this.healthCheckService.registerMonitoredPartition(zeebePartition.getPartitionId(), zeebePartition);
        return zeebePartition;
    }

    private StateController createStateController(RaftPartition raftPartition, ConstructableSnapshotStore snapshotStore, ConcurrencyControl concurrencyControl) {
        Path runtimeDirectory;
        if (this.brokerCfg.getData().useSeparateRuntimeDirectory()) {
            Path rootRuntimeDirectory = Paths.get(this.brokerCfg.getData().getRuntimeDirectory(), new String[0]);
            try {
                FileUtil.ensureDirectoryExists((Path)rootRuntimeDirectory);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Runtime directory %s does not exist".formatted(rootRuntimeDirectory), e);
            }
            runtimeDirectory = rootRuntimeDirectory.resolve(String.valueOf(raftPartition.id().id()));
        } else {
            runtimeDirectory = raftPartition.dataDirectory().toPath().resolve("runtime");
        }
        RocksdbCfg databaseCfg = this.brokerCfg.getExperimental().getRocksdb();
        ConsistencyCheckCfg consistencyChecks = this.brokerCfg.getExperimental().getConsistencyChecks();
        return new StateControllerImpl((ZeebeDbFactory)new ZeebeRocksDbFactory(databaseCfg.createRocksDbConfiguration(), consistencyChecks.getSettings()), snapshotStore, runtimeDirectory, new AtomixRecordEntrySupplierImpl(raftPartition.getServer()), StatePositionSupplier::getHighestExportedPosition, concurrencyControl);
    }

    private TypedRecordProcessorsFactory createFactory(BrokerInfo localBroker, FeatureFlags featureFlags) {
        return recordProcessorContext -> {
            InterPartitionCommandSender partitionCommandSender = recordProcessorContext.getPartitionCommandSender();
            SubscriptionCommandSender subscriptionCommandSender = new SubscriptionCommandSender(recordProcessorContext.getPartitionId(), partitionCommandSender);
            return EngineProcessors.createEngineProcessors((TypedRecordProcessorContext)recordProcessorContext, (int)localBroker.getPartitionsCount(), (SubscriptionCommandSender)subscriptionCommandSender, (InterPartitionCommandSender)partitionCommandSender, (FeatureFlags)featureFlags, (JobStreamer)this.jobStreamer);
        };
    }
}

