/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.partitioning.topology;

import io.atomix.cluster.MemberId;
import io.camunda.zeebe.broker.bootstrap.BrokerStartupContext;
import io.camunda.zeebe.broker.partitioning.topology.ClusterTopologyService;
import io.camunda.zeebe.broker.partitioning.topology.PartitionDistribution;
import io.camunda.zeebe.broker.partitioning.topology.PartitionDistributionResolver;
import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.future.CompletableActorFuture;
import io.camunda.zeebe.topology.ClusterTopologyManagerService;
import io.camunda.zeebe.topology.StaticConfiguration;
import io.camunda.zeebe.topology.gossip.ClusterTopologyGossiperConfig;
import io.camunda.zeebe.topology.state.ClusterTopology;
import io.camunda.zeebe.topology.util.TopologyUtil;
import java.nio.file.Path;
import java.time.Duration;

public class DynamicClusterTopologyService
implements ClusterTopologyService {
    private PartitionDistribution partitionDistribution;
    private ClusterTopologyManagerService clusterTopologyManagerService;

    @Override
    public PartitionDistribution getPartitionDistribution() {
        return this.partitionDistribution;
    }

    @Override
    public ActorFuture<Void> start(BrokerStartupContext brokerStartupContext) {
        CompletableActorFuture started = new CompletableActorFuture();
        this.clusterTopologyManagerService = this.getClusterTopologyManagerService(brokerStartupContext);
        ActorFuture<Void> topologyManagerStartedFuture = DynamicClusterTopologyService.startClusterTopologyManager(brokerStartupContext, this.clusterTopologyManagerService);
        topologyManagerStartedFuture.onComplete((ignore, topologyManagerFailed) -> {
            if (topologyManagerFailed != null) {
                started.completeExceptionally(topologyManagerFailed);
            } else {
                this.clusterTopologyManagerService.getClusterTopology().onComplete((topology, error) -> {
                    if (error != null) {
                        started.completeExceptionally(error);
                    } else {
                        try {
                            this.partitionDistribution = new PartitionDistribution(TopologyUtil.getPartitionDistributionFrom((ClusterTopology)topology, (String)"raft-partition"));
                            started.complete(null);
                        }
                        catch (Exception topologyConversionFailed) {
                            started.completeExceptionally((Throwable)topologyConversionFailed);
                        }
                    }
                });
            }
        });
        return started;
    }

    public ActorFuture<Void> closeAsync() {
        this.partitionDistribution = null;
        if (this.clusterTopologyManagerService != null) {
            return this.clusterTopologyManagerService.closeAsync();
        }
        return CompletableActorFuture.completed(null);
    }

    private static ActorFuture<Void> startClusterTopologyManager(BrokerStartupContext brokerStartupContext, ClusterTopologyManagerService clusterTopologyManagerService) {
        BrokerCfg brokerConfiguration = brokerStartupContext.getBrokerConfiguration();
        MemberId localMember = brokerStartupContext.getClusterServices().getMembershipService().getLocalMember().id();
        StaticConfiguration staticConfiguration = PartitionDistributionResolver.getStaticConfiguration(brokerConfiguration.getCluster(), brokerConfiguration.getExperimental().getPartitioning(), localMember);
        return clusterTopologyManagerService.start(brokerStartupContext.getActorSchedulingService(), staticConfiguration);
    }

    private ClusterTopologyManagerService getClusterTopologyManagerService(BrokerStartupContext brokerStartupContext) {
        Path rootDirectory = Path.of(brokerStartupContext.getBrokerConfiguration().getData().getDirectory(), new String[0]);
        return new ClusterTopologyManagerService(rootDirectory, brokerStartupContext.getClusterServices().getCommunicationService(), brokerStartupContext.getClusterServices().getMembershipService(), this.getDefaultClusterTopologyGossipConfig());
    }

    private ClusterTopologyGossiperConfig getDefaultClusterTopologyGossipConfig() {
        return new ClusterTopologyGossiperConfig(Duration.ofSeconds(10L), Duration.ofSeconds(2L), 2);
    }
}

