/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.partitioning.topology;

import io.atomix.cluster.MemberId;
import io.camunda.zeebe.broker.bootstrap.BrokerStartupContext;
import io.camunda.zeebe.broker.partitioning.topology.ClusterTopologyService;
import io.camunda.zeebe.broker.partitioning.topology.PartitionDistribution;
import io.camunda.zeebe.broker.partitioning.topology.PartitionDistributionResolver;
import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.future.CompletableActorFuture;
import io.camunda.zeebe.topology.StaticConfiguration;

public class StaticClusterTopologyService
implements ClusterTopologyService {
    private PartitionDistribution partitionDistribution;

    @Override
    public PartitionDistribution getPartitionDistribution() {
        return this.partitionDistribution;
    }

    @Override
    public ActorFuture<Void> start(BrokerStartupContext brokerStartupContext) {
        try {
            BrokerCfg brokerConfiguration = brokerStartupContext.getBrokerConfiguration();
            MemberId localMember = brokerStartupContext.getClusterServices().getMembershipService().getLocalMember().id();
            StaticConfiguration staticConfiguration = PartitionDistributionResolver.getStaticConfiguration(brokerConfiguration.getCluster(), brokerConfiguration.getExperimental().getPartitioning(), localMember);
            this.partitionDistribution = new PartitionDistribution(staticConfiguration.generatePartitionDistribution());
        }
        catch (Exception e) {
            return CompletableActorFuture.completedExceptionally((Throwable)e);
        }
        return CompletableActorFuture.completed(null);
    }

    public ActorFuture<Void> closeAsync() {
        this.partitionDistribution = null;
        return CompletableActorFuture.completed(null);
    }
}

