/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system;

import io.camunda.zeebe.broker.clustering.ClusterServices;
import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.gateway.Gateway;
import io.camunda.zeebe.gateway.Loggers;
import io.camunda.zeebe.gateway.impl.broker.BrokerClient;
import io.camunda.zeebe.gateway.impl.broker.BrokerClientImpl;
import io.camunda.zeebe.gateway.impl.broker.cluster.BrokerTopologyListener;
import io.camunda.zeebe.gateway.impl.configuration.GatewayCfg;
import io.camunda.zeebe.gateway.impl.stream.JobStreamClient;
import io.camunda.zeebe.scheduler.ActorSchedulingService;
import io.camunda.zeebe.scheduler.ConcurrencyControl;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.future.ActorFutureCollector;
import java.util.Collection;
import java.util.stream.Stream;
import org.agrona.CloseHelper;

public final class EmbeddedGatewayService
implements AutoCloseable {
    private final Gateway gateway;
    private final BrokerClientImpl brokerClient;
    private final JobStreamClient jobStreamClient;
    private final ConcurrencyControl concurrencyControl;

    public EmbeddedGatewayService(BrokerCfg configuration, ActorSchedulingService actorScheduler, ClusterServices clusterServices, ConcurrencyControl concurrencyControl, JobStreamClient jobStreamClient) {
        this.concurrencyControl = concurrencyControl;
        this.brokerClient = new BrokerClientImpl(configuration.getGateway().getCluster().getRequestTimeout(), clusterServices.getMessagingService(), clusterServices.getMembershipService(), clusterServices.getEventService(), actorScheduler);
        this.jobStreamClient = jobStreamClient;
        this.gateway = new Gateway((GatewayCfg)configuration.getGateway(), (BrokerClient)this.brokerClient, actorScheduler, jobStreamClient.streamer());
    }

    @Override
    public void close() {
        CloseHelper.closeAll(error -> Loggers.GATEWAY_LOGGER.warn("Error occurred while shutting down embedded gateway", error), (AutoCloseable[])new AutoCloseable[]{this.gateway, this.brokerClient, this.jobStreamClient});
    }

    public Gateway get() {
        return this.gateway;
    }

    public ActorFuture<Gateway> start() {
        ActorFuture jobStreamClientStart = this.jobStreamClient.start();
        Collection brokerClientStart = this.brokerClient.start();
        ActorFuture allStart = (ActorFuture)Stream.concat(Stream.of(jobStreamClientStart), brokerClientStart.stream()).collect(new ActorFutureCollector(this.concurrencyControl));
        this.concurrencyControl.runOnCompletion(allStart, (ok, error) -> this.brokerClient.getTopologyManager().addTopologyListener((BrokerTopologyListener)this.jobStreamClient));
        return this.gateway.start();
    }
}

