/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.partitioning;

import io.atomix.raft.partition.RaftPartition;
import io.camunda.zeebe.broker.partitioning.startup.PartitionStartupContext;
import io.camunda.zeebe.broker.partitioning.startup.steps.PartitionDirectoryStep;
import io.camunda.zeebe.broker.partitioning.startup.steps.PartitionRegistrationStep;
import io.camunda.zeebe.broker.partitioning.startup.steps.RaftBootstrapStep;
import io.camunda.zeebe.broker.partitioning.startup.steps.RaftJoinStep;
import io.camunda.zeebe.broker.partitioning.startup.steps.SnapshotStoreStep;
import io.camunda.zeebe.broker.partitioning.startup.steps.ZeebePartitionStep;
import io.camunda.zeebe.broker.system.partitions.ZeebePartition;
import io.camunda.zeebe.scheduler.ConcurrencyControl;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.startup.StartupProcess;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Partition {
    private static final Logger LOGGER = LoggerFactory.getLogger(Partition.class);
    private final PartitionStartupContext context;
    private final StartupProcess<PartitionStartupContext> startupProcess;

    private Partition(PartitionStartupContext context, StartupProcess<PartitionStartupContext> startupProcess) {
        this.context = context;
        this.startupProcess = startupProcess;
    }

    public static Partition bootstrapping(PartitionStartupContext context) {
        return new Partition(context, (StartupProcess<PartitionStartupContext>)new StartupProcess(LOGGER, List.of(new PartitionDirectoryStep(), new SnapshotStoreStep(), new RaftBootstrapStep(), new ZeebePartitionStep(), new PartitionRegistrationStep())));
    }

    public static Partition joining(PartitionStartupContext context) {
        return new Partition(context, (StartupProcess<PartitionStartupContext>)new StartupProcess(List.of(new PartitionDirectoryStep(), new SnapshotStoreStep(), new RaftJoinStep(), new ZeebePartitionStep(), new PartitionRegistrationStep())));
    }

    public ActorFuture<Partition> start() {
        ConcurrencyControl concurrencyControl = this.context.concurrencyControl();
        ActorFuture result = concurrencyControl.createFuture();
        concurrencyControl.run(() -> {
            ActorFuture start = this.startupProcess.startup(concurrencyControl, (Object)this.context);
            concurrencyControl.runOnCompletion(start, (ok, error) -> {
                if (error != null) {
                    result.completeExceptionally(error);
                } else {
                    result.complete((Object)this);
                }
            });
        });
        return result;
    }

    public ActorFuture<Partition> stop() {
        ConcurrencyControl concurrencyControl = this.context.concurrencyControl();
        ActorFuture result = concurrencyControl.createFuture();
        concurrencyControl.run(() -> {
            ActorFuture start = this.startupProcess.shutdown(concurrencyControl, (Object)this.context);
            concurrencyControl.runOnCompletion(start, (ok, error) -> {
                if (error != null) {
                    result.completeExceptionally(error);
                } else {
                    result.complete((Object)this);
                }
            });
        });
        return result;
    }

    public ZeebePartition zeebePartition() {
        return this.context.zeebePartition();
    }

    public RaftPartition raftPartition() {
        return this.context.raftPartition();
    }

    public int id() {
        return (Integer)this.context.partitionMetadata().id().id();
    }
}

