/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.partitioning.topology;

import io.atomix.cluster.MemberId;
import io.atomix.primitive.partition.PartitionId;
import io.camunda.zeebe.broker.partitioning.distribution.FixedPartitionDistributor;
import io.camunda.zeebe.broker.partitioning.distribution.FixedPartitionDistributorBuilder;
import io.camunda.zeebe.broker.partitioning.distribution.RoundRobinPartitionDistributor;
import io.camunda.zeebe.broker.system.configuration.ClusterCfg;
import io.camunda.zeebe.broker.system.configuration.PartitioningCfg;
import io.camunda.zeebe.broker.system.configuration.partitioning.FixedPartitionCfg;
import io.camunda.zeebe.broker.system.configuration.partitioning.Scheme;
import io.camunda.zeebe.topology.PartitionDistributor;
import io.camunda.zeebe.topology.StaticConfiguration;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public final class PartitionDistributionResolver {
    private PartitionDistributionResolver() {
    }

    public static StaticConfiguration getStaticConfiguration(ClusterCfg clusterCfg, PartitioningCfg partitioningCfg, MemberId localMemberId) {
        Set<MemberId> allMembers = PartitionDistributionResolver.getRaftGroupMembers(clusterCfg);
        return new StaticConfiguration(PartitionDistributionResolver.getPartitionDistributor(partitioningCfg), allMembers, localMemberId, PartitionDistributionResolver.getSortedPartitionIds(clusterCfg.getPartitionsCount()), clusterCfg.getReplicationFactor());
    }

    static PartitionDistributor getPartitionDistributor(PartitioningCfg partitionCfg) {
        return PartitionDistributionResolver.buildPartitionDistributor(partitionCfg);
    }

    private static PartitionDistributor buildPartitionDistributor(PartitioningCfg config) {
        return config.getScheme() == Scheme.FIXED ? PartitionDistributionResolver.buildFixedPartitionDistributor(config) : new RoundRobinPartitionDistributor();
    }

    private static FixedPartitionDistributor buildFixedPartitionDistributor(PartitioningCfg config) {
        FixedPartitionDistributorBuilder distributionBuilder = new FixedPartitionDistributorBuilder("raft-partition");
        for (FixedPartitionCfg partition : config.getFixed()) {
            for (FixedPartitionCfg.NodeCfg node : partition.getNodes()) {
                distributionBuilder.assignMember(partition.getPartitionId(), node.getNodeId(), node.getPriority());
            }
        }
        return distributionBuilder.build();
    }

    private static Set<MemberId> getRaftGroupMembers(ClusterCfg clusterCfg) {
        int clusterSize = clusterCfg.getClusterSize();
        return IntStream.range(0, clusterSize).mapToObj(nodeId -> MemberId.from((String)Integer.toString(nodeId))).collect(Collectors.toSet());
    }

    static List<PartitionId> getSortedPartitionIds(int partitionCount) {
        return IntStream.rangeClosed(1, partitionCount).mapToObj(p -> PartitionId.from((String)"raft-partition", (int)p)).sorted().toList();
    }
}

