/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.partitions.impl.steps;

import io.camunda.zeebe.broker.system.partitions.PartitionStartupContext;
import io.camunda.zeebe.broker.system.partitions.PartitionStartupStep;
import io.camunda.zeebe.db.impl.rocksdb.ZeebeRocksDBMetricExporter;
import io.camunda.zeebe.scheduler.ScheduledTimer;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.future.CompletableActorFuture;
import java.time.Duration;

public class RockDbMetricExporterPartitionStartupStep
implements PartitionStartupStep {
    public String getName() {
        return "RocksDB metric timer";
    }

    public ActorFuture<PartitionStartupContext> startup(PartitionStartupContext partitionStartupContext) {
        ZeebeRocksDBMetricExporter metricExporter = new ZeebeRocksDBMetricExporter(Integer.toString(partitionStartupContext.getPartitionId()), partitionStartupContext::getZeebeDb);
        ScheduledTimer metricsTimer = partitionStartupContext.getActorControl().runAtFixedRate(Duration.ofSeconds(5L), () -> {
            if (partitionStartupContext.getZeebeDb() != null) {
                metricExporter.exportMetrics();
            }
        });
        partitionStartupContext.setMetricsTimer(metricsTimer);
        return CompletableActorFuture.completed((Object)partitionStartupContext);
    }

    public ActorFuture<PartitionStartupContext> shutdown(PartitionStartupContext partitionStartupContext) {
        partitionStartupContext.getMetricsTimer().cancel();
        partitionStartupContext.setMetricsTimer(null);
        return CompletableActorFuture.completed((Object)partitionStartupContext);
    }
}

