/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker;

import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.broker.system.configuration.SecurityCfg;
import io.camunda.zeebe.broker.test.EmbeddedBrokerRule;
import io.camunda.zeebe.test.util.asserts.SslAssert;
import io.netty.handler.ssl.util.SelfSignedCertificate;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.cert.CertificateException;
import org.agrona.LangUtil;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.ExternalResource;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public final class BrokerNetworkSecurityTest {
    @ClassRule
    public static final SecuredEmbeddedBrokerRule BROKER_RULE = new SecuredEmbeddedBrokerRule();

    @Test
    public void shouldSecureCommandApi() {
        InetSocketAddress commandApiAddress = BrokerNetworkSecurityTest.BROKER_RULE.broker.getBrokerCfg().getNetwork().getCommandApi().getAddress();
        SslAssert.assertThat((SocketAddress)commandApiAddress).isSecuredBy(BrokerNetworkSecurityTest.BROKER_RULE.certificate);
    }

    @Test
    public void shouldSecureInternalApi() {
        InetSocketAddress internalApiAddress = BrokerNetworkSecurityTest.BROKER_RULE.broker.getBrokerCfg().getNetwork().getInternalApi().getAddress();
        SslAssert.assertThat((SocketAddress)internalApiAddress).isSecuredBy(BrokerNetworkSecurityTest.BROKER_RULE.certificate);
    }

    private static final class SecuredEmbeddedBrokerRule
    extends ExternalResource {
        private SelfSignedCertificate certificate;
        private EmbeddedBrokerRule broker;

        private SecuredEmbeddedBrokerRule() {
        }

        public Statement apply(Statement base, Description description) {
            try {
                this.certificate = new SelfSignedCertificate();
            }
            catch (CertificateException e) {
                LangUtil.rethrowUnchecked((Throwable)e);
            }
            this.broker = new EmbeddedBrokerRule(this::configureBroker);
            Statement statement = super.apply(base, description);
            return this.broker.apply(statement, description);
        }

        private void configureBroker(BrokerCfg config) {
            config.getNetwork().setSecurity(new SecurityCfg().setEnabled(true).setCertificateChainPath(this.certificate.certificate()).setPrivateKeyPath(this.certificate.privateKey()));
        }
    }
}

