/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker;

import io.atomix.cluster.AtomixCluster;
import io.camunda.zeebe.broker.Broker;
import io.camunda.zeebe.broker.PartitionListener;
import io.camunda.zeebe.broker.SpringBrokerBridge;
import io.camunda.zeebe.broker.client.api.BrokerClient;
import io.camunda.zeebe.broker.system.SystemContext;
import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.broker.test.EmbeddedBrokerRule;
import io.camunda.zeebe.broker.test.TestActorSchedulerFactory;
import io.camunda.zeebe.broker.test.TestBrokerClientFactory;
import io.camunda.zeebe.broker.test.TestClusterFactory;
import io.camunda.zeebe.engine.state.QueryService;
import io.camunda.zeebe.logstreams.log.LogStream;
import io.camunda.zeebe.scheduler.ActorScheduler;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.future.CompletableActorFuture;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.io.File;
import java.time.Duration;
import java.util.Collections;
import java.util.concurrent.CountDownLatch;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.Mockito;

public final class SimpleBrokerStartTest {
    private static final SpringBrokerBridge TEST_SPRING_BROKER_BRIDGE = new SpringBrokerBridge();
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private File newTemporaryFolder;
    private final MeterRegistry meterRegistry = new SimpleMeterRegistry();

    @Before
    public void setup() throws Exception {
        this.newTemporaryFolder = this.temporaryFolder.newFolder();
    }

    @Test
    public void shouldFailToCreateBrokerWithSmallSnapshotPeriod() {
        BrokerCfg brokerCfg = new BrokerCfg();
        brokerCfg.getData().setSnapshotPeriod(Duration.ofMillis(1L));
        brokerCfg.init(this.newTemporaryFolder.getAbsolutePath());
        AbstractThrowableAssert catchedThrownBy = Assertions.assertThatThrownBy(() -> {
            SystemContext systemContext = new SystemContext(brokerCfg, (ActorScheduler)Mockito.mock(ActorScheduler.class), (AtomixCluster)Mockito.mock(AtomixCluster.class), (BrokerClient)Mockito.mock(BrokerClient.class));
            new Broker(systemContext, TEST_SPRING_BROKER_BRIDGE);
        });
        catchedThrownBy.isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void shouldCallPartitionListenerAfterStart() throws Exception {
        BrokerCfg brokerCfg = new BrokerCfg();
        EmbeddedBrokerRule.assignSocketAddresses(brokerCfg);
        brokerCfg.init(this.newTemporaryFolder.getAbsolutePath());
        AtomixCluster atomixCluster = TestClusterFactory.createAtomixCluster(brokerCfg, this.meterRegistry);
        ActorScheduler actorScheduler = TestActorSchedulerFactory.ofBrokerConfig(brokerCfg);
        BrokerClient brokerClient = TestBrokerClientFactory.createBrokerClient(atomixCluster, actorScheduler);
        SystemContext systemContext = new SystemContext(brokerCfg, actorScheduler, atomixCluster, brokerClient);
        final CountDownLatch leaderLatch = new CountDownLatch(1);
        PartitionListener listener = new PartitionListener(){

            public ActorFuture<Void> onBecomingFollower(int partitionId, long term) {
                return CompletableActorFuture.completed(null);
            }

            public ActorFuture<Void> onBecomingLeader(int partitionId, long term, LogStream logStream, QueryService queryService) {
                leaderLatch.countDown();
                return CompletableActorFuture.completed(null);
            }

            public ActorFuture<Void> onBecomingInactive(int partitionId, long term) {
                return CompletableActorFuture.completed(null);
            }
        };
        Broker broker = new Broker(systemContext, TEST_SPRING_BROKER_BRIDGE, Collections.singletonList(listener));
        broker.start().join();
        leaderLatch.await();
        broker.close();
        systemContext.getScheduler().stop().get();
    }
}

