/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.backup;

import io.camunda.zeebe.backup.api.Backup;
import io.camunda.zeebe.backup.api.BackupIdentifier;
import io.camunda.zeebe.backup.api.BackupIdentifierWildcard;
import io.camunda.zeebe.backup.api.BackupStatus;
import io.camunda.zeebe.backup.api.BackupStatusCode;
import io.camunda.zeebe.backup.api.BackupStore;
import java.io.FileNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;

public class InMemoryMockBackupStore
implements BackupStore,
AutoCloseable {
    private final ConcurrentHashMap<BackupIdentifier, CompletableFuture<Void>> saveFutures = new ConcurrentHashMap();
    private final ConcurrentHashMap<BackupIdentifier, BackupStatus> backupStatusMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<BackupIdentifier, Backup> backupMap = new ConcurrentHashMap();

    public Set<BackupIdentifier> backupInProgress() {
        return this.backupMap.keySet();
    }

    public CompletableFuture<Void> save(Backup backup) {
        this.backupMap.put(backup.id(), backup);
        CompletableFuture<Void> fut = new CompletableFuture<Void>();
        this.saveFutures.put(backup.id(), fut);
        return fut;
    }

    public CompletableFuture<BackupStatus> getStatus(BackupIdentifier id) {
        return CompletableFuture.completedFuture(this.backupStatusMap.get(id));
    }

    public CompletableFuture<Collection<BackupStatus>> list(BackupIdentifierWildcard wildcard) {
        return CompletableFuture.completedFuture(this.backupStatusMap.entrySet().stream().filter(e -> wildcard.matches((BackupIdentifier)e.getKey())).map(Map.Entry::getValue).toList());
    }

    public CompletableFuture<Void> delete(BackupIdentifier id) {
        this.backupStatusMap.remove(id);
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Backup> restore(BackupIdentifier id, Path targetFolder) {
        return CompletableFuture.completedFuture(this.backupMap.get(id));
    }

    public CompletableFuture<BackupStatusCode> markFailed(BackupIdentifier id, String failureReason) {
        throw new UnsupportedOperationException("Not yet implemented; implemented it when required");
    }

    public CompletableFuture<Void> closeAsync() {
        return CompletableFuture.completedFuture(null);
    }

    public void completeSaveFutures() {
        for (Map.Entry<BackupIdentifier, CompletableFuture<Void>> entry : this.saveFutures.entrySet()) {
            CompletableFuture<Void> future = entry.getValue();
            BackupIdentifier id = entry.getKey();
            Backup backup = this.backupMap.get(id);
            this.completeFuture(backup, future);
        }
        this.saveFutures.clear();
    }

    private void completeFuture(Backup backup, CompletableFuture<Void> future) {
        ArrayList allFiles = new ArrayList();
        allFiles.addAll(backup.snapshot().files());
        allFiles.addAll(backup.segments().files());
        for (Path path : allFiles) {
            if (Files.exists(path, new LinkOption[0])) continue;
            future.completeExceptionally(new FileNotFoundException("File not found %s".formatted(path)));
            break;
        }
        if (!future.isCompletedExceptionally()) {
            future.complete(null);
        }
    }

    @Override
    public void close() throws Exception {
        this.completeSaveFutures();
    }
}

