/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.bootstrap;

import io.atomix.cluster.messaging.ManagedMessagingService;
import io.camunda.zeebe.broker.SpringBrokerBridge;
import io.camunda.zeebe.broker.bootstrap.ApiMessagingServiceStep;
import io.camunda.zeebe.broker.bootstrap.BrokerStartupContext;
import io.camunda.zeebe.broker.bootstrap.BrokerStartupContextImpl;
import io.camunda.zeebe.broker.client.api.BrokerClient;
import io.camunda.zeebe.broker.clustering.ClusterServicesImpl;
import io.camunda.zeebe.broker.exporter.repo.ExporterRepository;
import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.broker.system.configuration.SocketBindingCfg;
import io.camunda.zeebe.broker.system.monitoring.BrokerHealthCheckService;
import io.camunda.zeebe.protocol.impl.encoding.BrokerInfo;
import io.camunda.zeebe.scheduler.Actor;
import io.camunda.zeebe.scheduler.ActorScheduler;
import io.camunda.zeebe.scheduler.ActorSchedulingService;
import io.camunda.zeebe.scheduler.ConcurrencyControl;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.testing.TestConcurrencyControl;
import io.camunda.zeebe.test.util.socket.SocketUtil;
import java.time.Duration;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

class ApiMessagingServiceStepTest {
    public static final Duration TEST_SHUTDOWN_TIMEOUT = Duration.ofSeconds(10L);
    private static final TestConcurrencyControl CONCURRENCY_CONTROL = new TestConcurrencyControl();
    private static final BrokerCfg TEST_BROKER_CONFIG = new BrokerCfg();
    private static final BrokerInfo TEST_BROKER_INFO = new BrokerInfo(0, "localhost");
    private static final Duration TIME_OUT = Duration.ofSeconds(10L);
    private final ActorScheduler mockActorSchedulingService = (ActorScheduler)Mockito.mock(ActorScheduler.class);
    private BrokerStartupContextImpl testBrokerStartupContext;
    private final ApiMessagingServiceStep sut = new ApiMessagingServiceStep();

    ApiMessagingServiceStepTest() {
    }

    @BeforeEach
    void setUp() {
        Mockito.when((Object)this.mockActorSchedulingService.submitActor((Actor)ArgumentMatchers.any())).thenReturn((Object)CONCURRENCY_CONTROL.completedFuture(null));
        this.testBrokerStartupContext = new BrokerStartupContextImpl(TEST_BROKER_INFO, TEST_BROKER_CONFIG, (SpringBrokerBridge)Mockito.mock(SpringBrokerBridge.class), (ActorSchedulingService)this.mockActorSchedulingService, (BrokerHealthCheckService)Mockito.mock(BrokerHealthCheckService.class), (ExporterRepository)Mockito.mock(ExporterRepository.class), (ClusterServicesImpl)Mockito.mock(ClusterServicesImpl.class, (Answer)Mockito.RETURNS_DEEP_STUBS), (BrokerClient)Mockito.mock(BrokerClient.class), Collections.emptyList(), TEST_SHUTDOWN_TIMEOUT);
        this.testBrokerStartupContext.setConcurrencyControl((ConcurrencyControl)CONCURRENCY_CONTROL);
    }

    @Test
    void shouldHaveDescriptiveName() {
        String actual = this.sut.getName();
        Assertions.assertThat((String)actual).isSameAs((Object)"API Messaging Service");
    }

    static {
        SocketBindingCfg.CommandApiCfg commandApiCfg = TEST_BROKER_CONFIG.getNetwork().getCommandApi();
        commandApiCfg.setHost("localhost");
        commandApiCfg.setAdvertisedHost("localhost");
    }

    @Nested
    class ShutdownBehavior {
        private ManagedMessagingService mockManagedMessagingService;
        private ActorFuture<BrokerStartupContext> shutdownFuture;

        ShutdownBehavior() {
        }

        @BeforeEach
        void setUp() {
            this.mockManagedMessagingService = (ManagedMessagingService)Mockito.mock(ManagedMessagingService.class);
            Mockito.when((Object)this.mockManagedMessagingService.stop()).thenReturn(CompletableFuture.completedFuture(null));
            this.shutdownFuture = CONCURRENCY_CONTROL.createFuture();
            ApiMessagingServiceStepTest.this.testBrokerStartupContext.setApiMessagingService(this.mockManagedMessagingService);
        }

        @Test
        void shouldStopAndUninstallMessagingService() {
            ApiMessagingServiceStepTest.this.sut.shutdownInternal((BrokerStartupContext)ApiMessagingServiceStepTest.this.testBrokerStartupContext, (ConcurrencyControl)CONCURRENCY_CONTROL, this.shutdownFuture);
            Awaitility.await().until(() -> this.shutdownFuture.isDone());
            ((ManagedMessagingService)Mockito.verify((Object)this.mockManagedMessagingService)).stop();
            ManagedMessagingService messagingService = ApiMessagingServiceStepTest.this.testBrokerStartupContext.getApiMessagingService();
            Assertions.assertThat((Object)messagingService).isNull();
        }

        @Test
        void shouldCompleteFutureExceptionally() {
            ManagedMessagingService failingMessagingService = (ManagedMessagingService)Mockito.mock(ManagedMessagingService.class);
            Exception exception = new Exception();
            Mockito.when((Object)failingMessagingService.stop()).thenReturn(CompletableFuture.failedFuture(exception));
            ApiMessagingServiceStepTest.this.testBrokerStartupContext.setApiMessagingService(failingMessagingService);
            ApiMessagingServiceStepTest.this.sut.shutdownInternal((BrokerStartupContext)ApiMessagingServiceStepTest.this.testBrokerStartupContext, (ConcurrencyControl)CONCURRENCY_CONTROL, this.shutdownFuture);
            Awaitility.await().until(() -> this.shutdownFuture.isCompletedExceptionally());
            Assertions.assertThat((Throwable)this.shutdownFuture.getException()).isEqualTo((Object)exception);
            Assertions.assertThat((Object)ApiMessagingServiceStepTest.this.testBrokerStartupContext.getApiMessagingService()).isNotNull();
        }

        @Test
        void shouldCompleteFuture() {
            ApiMessagingServiceStepTest.this.sut.shutdownInternal((BrokerStartupContext)ApiMessagingServiceStepTest.this.testBrokerStartupContext, (ConcurrencyControl)CONCURRENCY_CONTROL, this.shutdownFuture);
            Assertions.assertThat(this.shutdownFuture).succeedsWithin(TIME_OUT);
            Assertions.assertThat((Object)((BrokerStartupContext)this.shutdownFuture.join())).isNotNull();
        }
    }

    @Nested
    class StartupBehavior {
        private ActorFuture<BrokerStartupContext> startupFuture;

        StartupBehavior() {
        }

        @BeforeEach
        void setUp() {
            this.startupFuture = CONCURRENCY_CONTROL.createFuture();
            int port = SocketUtil.getNextAddress().getPort();
            SocketBindingCfg.CommandApiCfg commandApiCfg = TEST_BROKER_CONFIG.getNetwork().getCommandApi();
            commandApiCfg.setPort(port);
            commandApiCfg.setAdvertisedPort(port);
        }

        @AfterEach
        void tearDown() {
            ManagedMessagingService messagingService = ApiMessagingServiceStepTest.this.testBrokerStartupContext.getApiMessagingService();
            if (messagingService != null) {
                messagingService.stop().join();
            }
        }

        @Test
        void shouldCompleteFuture() {
            ApiMessagingServiceStepTest.this.sut.startupInternal((BrokerStartupContext)ApiMessagingServiceStepTest.this.testBrokerStartupContext, (ConcurrencyControl)CONCURRENCY_CONTROL, this.startupFuture);
            Assertions.assertThat(this.startupFuture).succeedsWithin(TIME_OUT);
            Assertions.assertThat((Object)((BrokerStartupContext)this.startupFuture.join())).isNotNull();
        }

        @Test
        void shouldStartAndInstallMessagingService() {
            ApiMessagingServiceStepTest.this.sut.startupInternal((BrokerStartupContext)ApiMessagingServiceStepTest.this.testBrokerStartupContext, (ConcurrencyControl)CONCURRENCY_CONTROL, this.startupFuture);
            Awaitility.await().until(() -> this.startupFuture.isDone());
            ManagedMessagingService messagingService = ApiMessagingServiceStepTest.this.testBrokerStartupContext.getApiMessagingService();
            Assertions.assertThat((Object)messagingService).isNotNull();
            Assertions.assertThat((boolean)messagingService.isRunning()).isTrue();
        }
    }
}

