/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.bootstrap;

import io.camunda.zeebe.broker.SpringBrokerBridge;
import io.camunda.zeebe.broker.bootstrap.BrokerAdminServiceStep;
import io.camunda.zeebe.broker.bootstrap.BrokerStartupContext;
import io.camunda.zeebe.broker.clustering.ClusterServicesImpl;
import io.camunda.zeebe.broker.system.management.BrokerAdminServiceImpl;
import io.camunda.zeebe.protocol.impl.encoding.BrokerInfo;
import io.camunda.zeebe.scheduler.Actor;
import io.camunda.zeebe.scheduler.ActorSchedulingService;
import io.camunda.zeebe.scheduler.ConcurrencyControl;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.testing.TestConcurrencyControl;
import java.time.Duration;
import java.util.function.Supplier;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

final class BrokerAdminServiceStepTest {
    private static final TestConcurrencyControl CONCURRENCY_CONTROL = new TestConcurrencyControl();
    private static final Duration TIME_OUT = Duration.ofSeconds(10L);
    private BrokerStartupContext mockBrokerStartupContext;
    private ActorSchedulingService mockActorSchedulingService;
    private SpringBrokerBridge mockSpringBrokerBridge;
    private BrokerAdminServiceImpl mockBrokerAdminService;
    private ActorFuture<BrokerStartupContext> future;
    private final BrokerAdminServiceStep sut = new BrokerAdminServiceStep();

    BrokerAdminServiceStepTest() {
    }

    @BeforeEach
    void setUp() {
        this.mockActorSchedulingService = (ActorSchedulingService)Mockito.mock(ActorSchedulingService.class);
        Mockito.when((Object)this.mockActorSchedulingService.submitActor((Actor)ArgumentMatchers.any())).thenReturn((Object)CONCURRENCY_CONTROL.completedFuture(null));
        this.mockSpringBrokerBridge = (SpringBrokerBridge)Mockito.mock(SpringBrokerBridge.class);
        this.mockBrokerAdminService = (BrokerAdminServiceImpl)Mockito.mock(BrokerAdminServiceImpl.class);
        Mockito.when((Object)this.mockBrokerAdminService.closeAsync()).thenReturn((Object)CONCURRENCY_CONTROL.completedFuture(null));
        this.mockBrokerStartupContext = (BrokerStartupContext)Mockito.mock(BrokerStartupContext.class);
        Mockito.when((Object)this.mockBrokerStartupContext.getConcurrencyControl()).thenReturn((Object)CONCURRENCY_CONTROL);
        Mockito.when((Object)this.mockBrokerStartupContext.getBrokerInfo()).thenReturn((Object)((BrokerInfo)Mockito.mock(BrokerInfo.class)));
        Mockito.when((Object)this.mockBrokerStartupContext.getActorSchedulingService()).thenReturn((Object)this.mockActorSchedulingService);
        Mockito.when((Object)this.mockBrokerStartupContext.getSpringBrokerBridge()).thenReturn((Object)this.mockSpringBrokerBridge);
        Mockito.when((Object)this.mockBrokerStartupContext.getBrokerAdminService()).thenReturn((Object)this.mockBrokerAdminService);
        Mockito.when((Object)this.mockBrokerStartupContext.getClusterServices()).thenReturn((Object)((ClusterServicesImpl)Mockito.mock(ClusterServicesImpl.class, (Answer)Mockito.RETURNS_DEEP_STUBS)));
        this.future = CONCURRENCY_CONTROL.createFuture();
    }

    @Test
    void shouldCompleteFutureOnStartup() {
        this.sut.startupInternal(this.mockBrokerStartupContext, (ConcurrencyControl)CONCURRENCY_CONTROL, this.future);
        Assertions.assertThat(this.future).succeedsWithin(TIME_OUT);
        Assertions.assertThat((Object)((BrokerStartupContext)this.future.join())).isNotNull();
    }

    @Test
    void shouldScheduleBrokerAdminServiceOnStartup() {
        this.sut.startupInternal(this.mockBrokerStartupContext, (ConcurrencyControl)CONCURRENCY_CONTROL, this.future);
        Awaitility.await().until(() -> this.future.isDone());
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(BrokerAdminServiceImpl.class);
        ((ActorSchedulingService)Mockito.verify((Object)this.mockActorSchedulingService)).submitActor((Actor)argumentCaptor.capture());
        ((BrokerStartupContext)Mockito.verify((Object)this.mockBrokerStartupContext)).setBrokerAdminService((BrokerAdminServiceImpl)argumentCaptor.getValue());
    }

    @Test
    void shouldRegisterBrokerAdminServiceInSpringBrokerBridgeOnStartup() {
        this.sut.startupInternal(this.mockBrokerStartupContext, (ConcurrencyControl)CONCURRENCY_CONTROL, this.future);
        Awaitility.await().until(() -> this.future.isDone());
        ArgumentCaptor adminServiceCaptor = ArgumentCaptor.forClass(BrokerAdminServiceImpl.class);
        ((BrokerStartupContext)Mockito.verify((Object)this.mockBrokerStartupContext)).setBrokerAdminService((BrokerAdminServiceImpl)adminServiceCaptor.capture());
        ArgumentCaptor adminServiceSupplierCaptor = ArgumentCaptor.forClass(Supplier.class);
        ((SpringBrokerBridge)Mockito.verify((Object)this.mockSpringBrokerBridge)).registerBrokerAdminServiceSupplier((Supplier)adminServiceSupplierCaptor.capture());
        Assertions.assertThat(((Supplier)adminServiceSupplierCaptor.getValue()).get()).isSameAs(adminServiceCaptor.getValue());
    }

    @Test
    void shouldCompleteFutureOnShutdown() {
        this.sut.shutdownInternal(this.mockBrokerStartupContext, (ConcurrencyControl)CONCURRENCY_CONTROL, this.future);
        Assertions.assertThat(this.future).succeedsWithin(TIME_OUT);
        Assertions.assertThat((Object)((BrokerStartupContext)this.future.join())).isNotNull();
    }

    @Test
    void shouldStopBrokerAdminServiceOnShutdown() {
        this.sut.shutdownInternal(this.mockBrokerStartupContext, (ConcurrencyControl)CONCURRENCY_CONTROL, this.future);
        Awaitility.await().until(() -> this.future.isDone());
        ((BrokerAdminServiceImpl)Mockito.verify((Object)this.mockBrokerAdminService)).closeAsync();
        ((BrokerStartupContext)Mockito.verify((Object)this.mockBrokerStartupContext)).setBrokerAdminService(null);
    }
}

