/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.bootstrap;

import io.camunda.zeebe.broker.bootstrap.BrokerStartupContext;
import io.camunda.zeebe.broker.bootstrap.BrokerStepMetricDecorator;
import io.camunda.zeebe.broker.system.monitoring.BrokerStepMetrics;
import io.camunda.zeebe.broker.system.monitoring.BrokerStepMetricsDoc;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.startup.StartupStep;
import io.camunda.zeebe.scheduler.testing.TestConcurrencyControl;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.MockClock;
import io.micrometer.core.instrument.TimeGauge;
import io.micrometer.core.instrument.simple.SimpleConfig;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class BrokerStepMetricDecoratorTest {
    private static final TestConcurrencyControl CONCURRENCY_CONTROL = new TestConcurrencyControl();
    private static final String DELEGATE_STEP_NAME = "delegate step";
    private final MockClock clock = new MockClock();
    private final SimpleMeterRegistry registry = new SimpleMeterRegistry(SimpleConfig.DEFAULT, (Clock)this.clock);
    private final BrokerStepMetrics brokerStepMetrics = (BrokerStepMetrics)Mockito.spy((Object)new BrokerStepMetrics((MeterRegistry)this.registry));
    private BrokerStartupContext mockBrokerStartupContext;
    private StartupStep<BrokerStartupContext> mockStep;
    private BrokerStepMetricDecorator sut;
    private ActorFuture<BrokerStartupContext> startupFuture;
    private ActorFuture<BrokerStartupContext> shutdownFuture;

    BrokerStepMetricDecoratorTest() {
    }

    @BeforeEach
    void setUp() {
        this.mockBrokerStartupContext = (BrokerStartupContext)Mockito.mock(BrokerStartupContext.class);
        Mockito.when((Object)this.mockBrokerStartupContext.getConcurrencyControl()).thenReturn((Object)CONCURRENCY_CONTROL);
        this.startupFuture = CONCURRENCY_CONTROL.createFuture();
        this.shutdownFuture = CONCURRENCY_CONTROL.createFuture();
        this.mockStep = (StartupStep)Mockito.mock(StartupStep.class);
        Mockito.when((Object)this.mockStep.startup((Object)this.mockBrokerStartupContext)).thenReturn(this.startupFuture);
        Mockito.when((Object)this.mockStep.shutdown((Object)this.mockBrokerStartupContext)).thenReturn(this.shutdownFuture);
        Mockito.when((Object)this.mockStep.getName()).thenReturn((Object)DELEGATE_STEP_NAME);
        this.sut = new BrokerStepMetricDecorator(this.brokerStepMetrics, this.mockStep);
    }

    @Test
    void shouldCallStartupOnDelegate() {
        this.sut.startup(this.mockBrokerStartupContext);
        ((StartupStep)Mockito.verify(this.mockStep)).startup((Object)this.mockBrokerStartupContext);
    }

    @Test
    void shouldCallShutdownOnDelegate() {
        this.sut.shutdown(this.mockBrokerStartupContext);
        ((StartupStep)Mockito.verify(this.mockStep)).shutdown((Object)this.mockBrokerStartupContext);
    }

    @Test
    void shouldUpdateStartStepDuration() {
        this.sut.startup(this.mockBrokerStartupContext);
        this.clock.addSeconds(1L);
        this.startupFuture.complete((Object)this.mockBrokerStartupContext);
        TimeGauge gauge = this.registry.get(BrokerStepMetricsDoc.STARTUP.getName()).timeGauge();
        ((BrokerStepMetrics)Mockito.verify((Object)this.brokerStepMetrics, (VerificationMode)Mockito.times((int)1))).createStartupTimer((String)ArgumentMatchers.any());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.brokerStepMetrics});
        Assertions.assertThat((double)gauge.value(TimeUnit.MILLISECONDS)).isEqualTo((double)TimeUnit.SECONDS.toMillis(1L));
    }

    @Test
    void shouldUpdateShutdownStepDuration() {
        this.sut.shutdown(this.mockBrokerStartupContext);
        this.clock.addSeconds(1L);
        this.shutdownFuture.complete((Object)this.mockBrokerStartupContext);
        TimeGauge gauge = this.registry.get(BrokerStepMetricsDoc.CLOSE.getName()).timeGauge();
        ((BrokerStepMetrics)Mockito.verify((Object)this.brokerStepMetrics, (VerificationMode)Mockito.times((int)1))).createCloseTimer((String)ArgumentMatchers.any());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.brokerStepMetrics});
        Assertions.assertThat((double)gauge.value(TimeUnit.MILLISECONDS)).isEqualTo((double)TimeUnit.SECONDS.toMillis(1L));
    }

    @Test
    void shouldReturnNameOfDelegate() {
        String actual = this.sut.getName();
        Assertions.assertThat((String)actual).isEqualTo(DELEGATE_STEP_NAME);
    }
}

