/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.bootstrap;

import io.camunda.zeebe.broker.bootstrap.BrokerStartupContext;
import io.camunda.zeebe.broker.bootstrap.ClusterServicesStep;
import io.camunda.zeebe.broker.clustering.ClusterServicesImpl;
import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.scheduler.ConcurrencyControl;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.testing.TestConcurrencyControl;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class ClusterServicesStepTest {
    private static final BrokerCfg TEST_CONFIGURATION = new BrokerCfg();
    private static final TestConcurrencyControl CONCURRENCY_CONTROL = new TestConcurrencyControl();
    private static final Duration TIME_OUT = Duration.ofSeconds(10L);
    private BrokerStartupContext mockBrokerStartupContext;
    private ClusterServicesImpl mockClusterServices;
    private ActorFuture<BrokerStartupContext> future;
    private final ClusterServicesStep sut = new ClusterServicesStep();

    ClusterServicesStepTest() {
    }

    @BeforeEach
    void setUp() {
        this.mockBrokerStartupContext = (BrokerStartupContext)Mockito.mock(BrokerStartupContext.class);
        this.mockClusterServices = (ClusterServicesImpl)Mockito.mock(ClusterServicesImpl.class);
        Mockito.when((Object)this.mockClusterServices.start()).thenReturn(CompletableFuture.completedFuture(null));
        Mockito.when((Object)this.mockClusterServices.stop()).thenReturn(CompletableFuture.completedFuture(null));
        Mockito.when((Object)this.mockBrokerStartupContext.getConcurrencyControl()).thenReturn((Object)CONCURRENCY_CONTROL);
        Mockito.when((Object)this.mockBrokerStartupContext.getClusterServices()).thenReturn((Object)this.mockClusterServices);
        Mockito.when((Object)this.mockBrokerStartupContext.getBrokerConfiguration()).thenReturn((Object)TEST_CONFIGURATION);
        this.future = CONCURRENCY_CONTROL.createFuture();
    }

    @Test
    void shouldCompleteFutureOnStartup() {
        this.sut.startupInternal(this.mockBrokerStartupContext, (ConcurrencyControl)CONCURRENCY_CONTROL, this.future);
        Assertions.assertThat(this.future).succeedsWithin(TIME_OUT);
        Assertions.assertThat((Object)((BrokerStartupContext)this.future.join())).isNotNull();
    }

    @Test
    void shouldCompleteFutureOnShutdown() {
        this.sut.shutdownInternal(this.mockBrokerStartupContext, (ConcurrencyControl)CONCURRENCY_CONTROL, this.future);
        Assertions.assertThat(this.future).succeedsWithin(TIME_OUT);
        Assertions.assertThat((Object)((BrokerStartupContext)this.future.join())).isNotNull();
    }

    @Test
    void shouldStopClusterServicesOnShutdown() {
        this.sut.shutdownInternal(this.mockBrokerStartupContext, (ConcurrencyControl)CONCURRENCY_CONTROL, this.future);
        Awaitility.await().until(() -> this.future.isDone());
        ((ClusterServicesImpl)Mockito.verify((Object)this.mockClusterServices)).stop();
    }

    @Test
    void shouldStartClusterServicesOnStartup() {
        this.sut.startupInternal(this.mockBrokerStartupContext, (ConcurrencyControl)CONCURRENCY_CONTROL, this.future);
        Awaitility.await().until(() -> this.future.isDone());
        ((ClusterServicesImpl)Mockito.verify((Object)this.mockClusterServices)).start();
    }
}

