/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.bootstrap;

import io.camunda.zeebe.broker.SpringBrokerBridge;
import io.camunda.zeebe.broker.bootstrap.BrokerStartupContext;
import io.camunda.zeebe.broker.bootstrap.BrokerStartupContextImpl;
import io.camunda.zeebe.broker.bootstrap.CommandApiServiceStep;
import io.camunda.zeebe.broker.client.api.BrokerClient;
import io.camunda.zeebe.broker.clustering.ClusterServicesImpl;
import io.camunda.zeebe.broker.exporter.repo.ExporterRepository;
import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.broker.system.configuration.SocketBindingCfg;
import io.camunda.zeebe.broker.system.monitoring.BrokerHealthCheckService;
import io.camunda.zeebe.broker.system.monitoring.DiskSpaceUsageListener;
import io.camunda.zeebe.broker.system.monitoring.DiskSpaceUsageMonitor;
import io.camunda.zeebe.broker.system.monitoring.DiskSpaceUsageMonitorActor;
import io.camunda.zeebe.broker.transport.commandapi.CommandApiServiceImpl;
import io.camunda.zeebe.protocol.impl.encoding.BrokerInfo;
import io.camunda.zeebe.scheduler.Actor;
import io.camunda.zeebe.scheduler.ActorScheduler;
import io.camunda.zeebe.scheduler.ActorSchedulingService;
import io.camunda.zeebe.scheduler.ConcurrencyControl;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.testing.TestConcurrencyControl;
import io.camunda.zeebe.test.util.socket.SocketUtil;
import io.camunda.zeebe.transport.impl.AtomixServerTransport;
import java.time.Duration;
import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

class CommandApiServiceStepTest {
    public static final Duration TEST_SHUTDOWN_TIMEOUT = Duration.ofSeconds(10L);
    private static final TestConcurrencyControl CONCURRENCY_CONTROL = new TestConcurrencyControl();
    private static final BrokerCfg TEST_BROKER_CONFIG = new BrokerCfg();
    private static final BrokerInfo TEST_BROKER_INFO = new BrokerInfo(0, "localhost");
    private static final Duration TIME_OUT = Duration.ofSeconds(10L);
    private final ActorScheduler mockActorSchedulingService = (ActorScheduler)Mockito.mock(ActorScheduler.class);
    private BrokerStartupContextImpl testBrokerStartupContext;
    private final CommandApiServiceStep sut = new CommandApiServiceStep();

    CommandApiServiceStepTest() {
    }

    @BeforeEach
    void setUp() {
        Mockito.when((Object)this.mockActorSchedulingService.submitActor((Actor)ArgumentMatchers.any())).thenReturn((Object)CONCURRENCY_CONTROL.completedFuture(null));
        this.testBrokerStartupContext = new BrokerStartupContextImpl(TEST_BROKER_INFO, TEST_BROKER_CONFIG, (SpringBrokerBridge)Mockito.mock(SpringBrokerBridge.class), (ActorSchedulingService)this.mockActorSchedulingService, (BrokerHealthCheckService)Mockito.mock(BrokerHealthCheckService.class), (ExporterRepository)Mockito.mock(ExporterRepository.class), (ClusterServicesImpl)Mockito.mock(ClusterServicesImpl.class, (Answer)Mockito.RETURNS_DEEP_STUBS), (BrokerClient)Mockito.mock(BrokerClient.class), Collections.emptyList(), TEST_SHUTDOWN_TIMEOUT);
        this.testBrokerStartupContext.setConcurrencyControl((ConcurrencyControl)CONCURRENCY_CONTROL);
        this.testBrokerStartupContext.setDiskSpaceUsageMonitor((DiskSpaceUsageMonitor)Mockito.mock(DiskSpaceUsageMonitorActor.class));
        this.testBrokerStartupContext.setGatewayBrokerTransport((AtomixServerTransport)Mockito.mock(AtomixServerTransport.class));
    }

    @Test
    void shouldHaveDescriptiveName() {
        String actual = this.sut.getName();
        Assertions.assertThat((String)actual).isSameAs((Object)"Command API");
    }

    static {
        SocketBindingCfg.CommandApiCfg commandApiCfg = TEST_BROKER_CONFIG.getNetwork().getCommandApi();
        commandApiCfg.setHost("localhost");
        commandApiCfg.setAdvertisedHost("localhost");
    }

    @Nested
    class ShutdownBehavior {
        private CommandApiServiceImpl mockCommandApiService;
        private AtomixServerTransport mockAtomixServerTransport;
        private ActorFuture<BrokerStartupContext> shutdownFuture;

        ShutdownBehavior() {
        }

        @BeforeEach
        void setUp() {
            this.mockCommandApiService = (CommandApiServiceImpl)Mockito.mock(CommandApiServiceImpl.class);
            Mockito.when((Object)this.mockCommandApiService.closeAsync()).thenReturn((Object)CONCURRENCY_CONTROL.completedFuture(null));
            this.mockAtomixServerTransport = (AtomixServerTransport)Mockito.mock(AtomixServerTransport.class);
            Mockito.when((Object)this.mockAtomixServerTransport.closeAsync()).thenReturn((Object)CONCURRENCY_CONTROL.completedFuture(null));
            CommandApiServiceStepTest.this.testBrokerStartupContext.setGatewayBrokerTransport(this.mockAtomixServerTransport);
            CommandApiServiceStepTest.this.testBrokerStartupContext.setCommandApiService(this.mockCommandApiService);
            CommandApiServiceStepTest.this.testBrokerStartupContext.setDiskSpaceUsageMonitor((DiskSpaceUsageMonitor)Mockito.mock(DiskSpaceUsageMonitorActor.class));
            CommandApiServiceStepTest.this.testBrokerStartupContext.getDiskSpaceUsageMonitor().addDiskUsageListener((DiskSpaceUsageListener)this.mockCommandApiService);
            this.shutdownFuture = CONCURRENCY_CONTROL.createFuture();
        }

        @Test
        void shouldRemoveCommandApiFromDiskSpaceUsageListenerList() {
            DiskSpaceUsageMonitorActor mockDiskSpaceUsageMonitor = (DiskSpaceUsageMonitorActor)Mockito.mock(DiskSpaceUsageMonitorActor.class);
            CommandApiServiceStepTest.this.testBrokerStartupContext.setDiskSpaceUsageMonitor((DiskSpaceUsageMonitor)mockDiskSpaceUsageMonitor);
            CommandApiServiceStepTest.this.sut.shutdownInternal((BrokerStartupContext)CommandApiServiceStepTest.this.testBrokerStartupContext, (ConcurrencyControl)CONCURRENCY_CONTROL, this.shutdownFuture);
            Awaitility.await().until(() -> this.shutdownFuture.isDone());
            ((DiskSpaceUsageMonitorActor)Mockito.verify((Object)mockDiskSpaceUsageMonitor)).removeDiskUsageListener((DiskSpaceUsageListener)this.mockCommandApiService);
        }

        @Test
        void shouldStopAndUninstallCommandApiService() {
            CommandApiServiceStepTest.this.sut.shutdownInternal((BrokerStartupContext)CommandApiServiceStepTest.this.testBrokerStartupContext, (ConcurrencyControl)CONCURRENCY_CONTROL, this.shutdownFuture);
            Awaitility.await().until(() -> this.shutdownFuture.isDone());
            ((CommandApiServiceImpl)Mockito.verify((Object)this.mockCommandApiService)).closeAsync();
            CommandApiServiceImpl commandApiService = CommandApiServiceStepTest.this.testBrokerStartupContext.getCommandApiService();
            Assertions.assertThat((Object)commandApiService).isNull();
        }

        @Test
        void shouldCompleteFuture() {
            CommandApiServiceStepTest.this.sut.shutdownInternal((BrokerStartupContext)CommandApiServiceStepTest.this.testBrokerStartupContext, (ConcurrencyControl)CONCURRENCY_CONTROL, this.shutdownFuture);
            Assertions.assertThat(this.shutdownFuture).succeedsWithin(TIME_OUT);
            Assertions.assertThat((Object)((BrokerStartupContext)this.shutdownFuture.join())).isNotNull();
        }
    }

    @Nested
    class StartupBehavior {
        private ActorFuture<BrokerStartupContext> startupFuture;

        StartupBehavior() {
        }

        @BeforeEach
        void setUp() {
            this.startupFuture = CONCURRENCY_CONTROL.createFuture();
            int port = SocketUtil.getNextAddress().getPort();
            SocketBindingCfg.CommandApiCfg commandApiCfg = TEST_BROKER_CONFIG.getNetwork().getCommandApi();
            commandApiCfg.setPort(port);
            commandApiCfg.setAdvertisedPort(port);
        }

        @Test
        void shouldCompleteFuture() {
            CommandApiServiceStepTest.this.sut.startupInternal((BrokerStartupContext)CommandApiServiceStepTest.this.testBrokerStartupContext, (ConcurrencyControl)CONCURRENCY_CONTROL, this.startupFuture);
            Assertions.assertThat(this.startupFuture).succeedsWithin(TIME_OUT);
            Assertions.assertThat((Object)((BrokerStartupContext)this.startupFuture.join())).isNotNull();
        }

        @Test
        void shouldStartAndInstallCommandApiService() {
            CommandApiServiceStepTest.this.sut.startupInternal((BrokerStartupContext)CommandApiServiceStepTest.this.testBrokerStartupContext, (ConcurrencyControl)CONCURRENCY_CONTROL, this.startupFuture);
            Awaitility.await().until(() -> this.startupFuture.isDone());
            CommandApiServiceImpl commandApiService = CommandApiServiceStepTest.this.testBrokerStartupContext.getCommandApiService();
            Assertions.assertThat((Object)commandApiService).isNotNull();
            ((ActorScheduler)Mockito.verify((Object)CommandApiServiceStepTest.this.mockActorSchedulingService)).submitActor((Actor)commandApiService);
        }

        @Test
        void shouldAddCommandApiServiceAsDiskSpaceUsageListener() {
            DiskSpaceUsageMonitorActor mockDiskSpaceUsageMonitor = (DiskSpaceUsageMonitorActor)Mockito.mock(DiskSpaceUsageMonitorActor.class);
            CommandApiServiceStepTest.this.testBrokerStartupContext.setDiskSpaceUsageMonitor((DiskSpaceUsageMonitor)mockDiskSpaceUsageMonitor);
            CommandApiServiceStepTest.this.sut.startupInternal((BrokerStartupContext)CommandApiServiceStepTest.this.testBrokerStartupContext, (ConcurrencyControl)CONCURRENCY_CONTROL, this.startupFuture);
            Awaitility.await().until(() -> this.startupFuture.isDone());
            CommandApiServiceImpl commandApiService = CommandApiServiceStepTest.this.testBrokerStartupContext.getCommandApiService();
            Assertions.assertThat((Object)commandApiService).isNotNull();
            ((DiskSpaceUsageMonitorActor)Mockito.verify((Object)mockDiskSpaceUsageMonitor)).addDiskUsageListener((DiskSpaceUsageListener)commandApiService);
        }
    }
}

