/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.bootstrap;

import io.camunda.zeebe.broker.bootstrap.BrokerStartupContext;
import io.camunda.zeebe.broker.bootstrap.DiskSpaceUsageMonitorStep;
import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.broker.system.monitoring.DiskSpaceUsageMonitor;
import io.camunda.zeebe.broker.system.monitoring.DiskSpaceUsageMonitorActor;
import io.camunda.zeebe.scheduler.Actor;
import io.camunda.zeebe.scheduler.ActorSchedulingService;
import io.camunda.zeebe.scheduler.ConcurrencyControl;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.testing.TestConcurrencyControl;
import java.time.Duration;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

class DiskSpaceUsageMonitorStepTest {
    private static final TestConcurrencyControl CONCURRENCY_CONTROL = new TestConcurrencyControl();
    private static final BrokerCfg TEST_BROKER_CONFIG = new BrokerCfg();
    private static final Duration TIME_OUT = Duration.ofSeconds(10L);
    private BrokerStartupContext mockBrokerStartupContext;
    private ActorSchedulingService mockActorSchedulingService;
    private DiskSpaceUsageMonitorActor mockDiskSpaceUsageMonitor;
    private ActorFuture<BrokerStartupContext> future;
    private final DiskSpaceUsageMonitorStep sut = new DiskSpaceUsageMonitorStep();

    DiskSpaceUsageMonitorStepTest() {
    }

    @BeforeEach
    void setUp() {
        this.mockBrokerStartupContext = (BrokerStartupContext)Mockito.mock(BrokerStartupContext.class);
        this.mockActorSchedulingService = (ActorSchedulingService)Mockito.mock(ActorSchedulingService.class);
        this.mockDiskSpaceUsageMonitor = (DiskSpaceUsageMonitorActor)Mockito.mock(DiskSpaceUsageMonitorActor.class);
        Mockito.when((Object)this.mockBrokerStartupContext.getBrokerConfiguration()).thenReturn((Object)TEST_BROKER_CONFIG);
        Mockito.when((Object)this.mockBrokerStartupContext.getConcurrencyControl()).thenReturn((Object)CONCURRENCY_CONTROL);
        Mockito.when((Object)this.mockBrokerStartupContext.getActorSchedulingService()).thenReturn((Object)this.mockActorSchedulingService);
        Mockito.when((Object)this.mockBrokerStartupContext.getDiskSpaceUsageMonitor()).thenReturn((Object)this.mockDiskSpaceUsageMonitor);
        Mockito.when((Object)this.mockDiskSpaceUsageMonitor.closeAsync()).thenReturn((Object)CONCURRENCY_CONTROL.completedFuture(null));
        Mockito.when((Object)this.mockActorSchedulingService.submitActor((Actor)ArgumentMatchers.any())).thenReturn((Object)CONCURRENCY_CONTROL.completedFuture(null));
        this.future = CONCURRENCY_CONTROL.createFuture();
    }

    @Test
    void shouldCompleteFutureOnStartup() {
        this.sut.startupInternal(this.mockBrokerStartupContext, (ConcurrencyControl)CONCURRENCY_CONTROL, this.future);
        Assertions.assertThat(this.future).succeedsWithin(TIME_OUT);
        Assertions.assertThat((Object)((BrokerStartupContext)this.future.join())).isNotNull();
    }

    @Test
    void shouldScheduleDiskSpaceUsageMonitorOnStartup() {
        this.sut.startupInternal(this.mockBrokerStartupContext, (ConcurrencyControl)CONCURRENCY_CONTROL, this.future);
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(DiskSpaceUsageMonitorActor.class);
        ((BrokerStartupContext)Mockito.verify((Object)this.mockBrokerStartupContext)).setDiskSpaceUsageMonitor((DiskSpaceUsageMonitor)argumentCaptor.capture());
        ((ActorSchedulingService)Mockito.verify((Object)this.mockActorSchedulingService)).submitActor((Actor)argumentCaptor.getValue());
    }

    @Test
    void shouldCompleteFutureOnShutdown() {
        this.sut.shutdownInternal(this.mockBrokerStartupContext, (ConcurrencyControl)CONCURRENCY_CONTROL, this.future);
        Assertions.assertThat(this.future).succeedsWithin(TIME_OUT);
        Assertions.assertThat((Object)((BrokerStartupContext)this.future.join())).isNotNull();
    }

    @Test
    void shouldStopHealthCheckServiceOnShutdown() {
        this.sut.shutdownInternal(this.mockBrokerStartupContext, (ConcurrencyControl)CONCURRENCY_CONTROL, this.future);
        Awaitility.await().until(() -> this.future.isDone());
        ((DiskSpaceUsageMonitorActor)Mockito.verify((Object)this.mockDiskSpaceUsageMonitor)).closeAsync();
        ((BrokerStartupContext)Mockito.verify((Object)this.mockBrokerStartupContext)).setDiskSpaceUsageMonitor(null);
    }
}

