/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.bootstrap;

import io.camunda.zeebe.broker.SpringBrokerBridge;
import io.camunda.zeebe.broker.bootstrap.BrokerStartupContext;
import io.camunda.zeebe.broker.bootstrap.BrokerStartupContextImpl;
import io.camunda.zeebe.broker.bootstrap.EmbeddedGatewayServiceStep;
import io.camunda.zeebe.broker.client.api.BrokerClient;
import io.camunda.zeebe.broker.clustering.ClusterServicesImpl;
import io.camunda.zeebe.broker.exporter.repo.ExporterRepository;
import io.camunda.zeebe.broker.system.EmbeddedGatewayService;
import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.broker.system.monitoring.BrokerHealthCheckService;
import io.camunda.zeebe.gateway.impl.configuration.NetworkCfg;
import io.camunda.zeebe.protocol.impl.encoding.BrokerInfo;
import io.camunda.zeebe.scheduler.Actor;
import io.camunda.zeebe.scheduler.ActorScheduler;
import io.camunda.zeebe.scheduler.ActorSchedulingService;
import io.camunda.zeebe.scheduler.ConcurrencyControl;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.testing.TestConcurrencyControl;
import io.camunda.zeebe.test.util.socket.SocketUtil;
import java.time.Duration;
import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

class EmbeddedGatewayServiceStepTest {
    private static final TestConcurrencyControl CONCURRENCY_CONTROL = new TestConcurrencyControl();
    private static final BrokerCfg TEST_BROKER_CONFIG = new BrokerCfg();
    private static final Duration TIME_OUT = Duration.ofSeconds(10L);
    private static final Duration TEST_SHUTDOWN_TIMEOUT = Duration.ofSeconds(10L);
    private final EmbeddedGatewayServiceStep sut = new EmbeddedGatewayServiceStep();
    private BrokerStartupContextImpl testBrokerStartupContext;

    EmbeddedGatewayServiceStepTest() {
    }

    @Test
    void shouldHaveDescriptiveName() {
        String actual = this.sut.getName();
        Assertions.assertThat((String)actual).isSameAs((Object)"Embedded Gateway");
    }

    static {
        NetworkCfg networkCfg = TEST_BROKER_CONFIG.getGateway().getNetwork();
        networkCfg.setHost("localhost");
    }

    @Nested
    class ShutdownBehavior {
        private EmbeddedGatewayService mockEmbeddedGatewayService;
        private ActorFuture<BrokerStartupContext> shutdownFuture;

        ShutdownBehavior() {
        }

        @BeforeEach
        void setUp() {
            this.mockEmbeddedGatewayService = (EmbeddedGatewayService)Mockito.mock(EmbeddedGatewayService.class);
            EmbeddedGatewayServiceStepTest.this.testBrokerStartupContext = new BrokerStartupContextImpl((BrokerInfo)Mockito.mock(BrokerInfo.class), TEST_BROKER_CONFIG, (SpringBrokerBridge)Mockito.mock(SpringBrokerBridge.class), (ActorSchedulingService)Mockito.mock(ActorScheduler.class), (BrokerHealthCheckService)Mockito.mock(BrokerHealthCheckService.class), (ExporterRepository)Mockito.mock(ExporterRepository.class), (ClusterServicesImpl)Mockito.mock(ClusterServicesImpl.class, (Answer)Mockito.RETURNS_DEEP_STUBS), (BrokerClient)Mockito.mock(BrokerClient.class), Collections.emptyList(), TEST_SHUTDOWN_TIMEOUT);
            EmbeddedGatewayServiceStepTest.this.testBrokerStartupContext.setEmbeddedGatewayService(this.mockEmbeddedGatewayService);
            this.shutdownFuture = CONCURRENCY_CONTROL.createFuture();
        }

        @Test
        void shouldStopAndUninstallEmbeddedGateway() {
            EmbeddedGatewayServiceStepTest.this.sut.shutdownInternal((BrokerStartupContext)EmbeddedGatewayServiceStepTest.this.testBrokerStartupContext, (ConcurrencyControl)CONCURRENCY_CONTROL, this.shutdownFuture);
            Awaitility.await().until(() -> this.shutdownFuture.isDone());
            ((EmbeddedGatewayService)Mockito.verify((Object)this.mockEmbeddedGatewayService)).close();
            EmbeddedGatewayService embeddedGatewayService = EmbeddedGatewayServiceStepTest.this.testBrokerStartupContext.getEmbeddedGatewayService();
            Assertions.assertThat((Object)embeddedGatewayService).isNull();
        }

        @Test
        void shouldCompleteFuture() {
            EmbeddedGatewayServiceStepTest.this.sut.shutdownInternal((BrokerStartupContext)EmbeddedGatewayServiceStepTest.this.testBrokerStartupContext, (ConcurrencyControl)CONCURRENCY_CONTROL, this.shutdownFuture);
            Assertions.assertThat(this.shutdownFuture).succeedsWithin(TIME_OUT);
            Assertions.assertThat((Object)((BrokerStartupContext)this.shutdownFuture.join())).isNotNull();
        }
    }

    @Nested
    class StartupBehavior {
        private ActorFuture<BrokerStartupContext> startupFuture;
        private ActorScheduler actorScheduler;
        private Actor actor;

        StartupBehavior() {
        }

        @BeforeEach
        void setUp() {
            this.actorScheduler = ActorScheduler.newActorScheduler().build();
            this.actorScheduler.start();
            this.startupFuture = CONCURRENCY_CONTROL.createFuture();
            EmbeddedGatewayServiceStepTest.this.testBrokerStartupContext = new BrokerStartupContextImpl((BrokerInfo)Mockito.mock(BrokerInfo.class), TEST_BROKER_CONFIG, (SpringBrokerBridge)Mockito.mock(SpringBrokerBridge.class), (ActorSchedulingService)this.actorScheduler, (BrokerHealthCheckService)Mockito.mock(BrokerHealthCheckService.class), (ExporterRepository)Mockito.mock(ExporterRepository.class), (ClusterServicesImpl)Mockito.mock(ClusterServicesImpl.class, (Answer)Mockito.RETURNS_DEEP_STUBS), (BrokerClient)Mockito.mock(BrokerClient.class), Collections.emptyList(), TEST_SHUTDOWN_TIMEOUT);
            int port = SocketUtil.getNextAddress().getPort();
            NetworkCfg commandApiCfg = TEST_BROKER_CONFIG.getGateway().getNetwork();
            commandApiCfg.setPort(port);
            this.actor = Actor.newActor().build();
            this.actorScheduler.submitActor(this.actor);
        }

        @AfterEach
        void tearDown() {
            EmbeddedGatewayService embeddedGatewayService = EmbeddedGatewayServiceStepTest.this.testBrokerStartupContext.getEmbeddedGatewayService();
            if (embeddedGatewayService != null) {
                embeddedGatewayService.close();
            }
            this.actorScheduler.stop();
        }

        @Test
        void shouldCompleteFuture() {
            this.actor.run(() -> EmbeddedGatewayServiceStepTest.this.sut.startupInternal((BrokerStartupContext)EmbeddedGatewayServiceStepTest.this.testBrokerStartupContext, (ConcurrencyControl)CONCURRENCY_CONTROL, this.startupFuture));
            Assertions.assertThat(this.startupFuture).succeedsWithin(TIME_OUT);
            Assertions.assertThat((Object)((BrokerStartupContext)this.startupFuture.join())).isNotNull();
        }

        @Test
        void shouldStartAndInstallEmbeddedGatewayService() {
            this.actor.run(() -> EmbeddedGatewayServiceStepTest.this.sut.startupInternal((BrokerStartupContext)EmbeddedGatewayServiceStepTest.this.testBrokerStartupContext, (ConcurrencyControl)CONCURRENCY_CONTROL, this.startupFuture));
            Awaitility.await().until(() -> this.startupFuture.isDone());
            EmbeddedGatewayService embeddedGatewayService = EmbeddedGatewayServiceStepTest.this.testBrokerStartupContext.getEmbeddedGatewayService();
            Assertions.assertThat((Object)embeddedGatewayService).isNotNull();
        }
    }
}

