/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.bootstrap;

import io.camunda.zeebe.broker.SpringBrokerBridge;
import io.camunda.zeebe.broker.bootstrap.BrokerStartupContext;
import io.camunda.zeebe.broker.bootstrap.BrokerStartupContextImpl;
import io.camunda.zeebe.broker.bootstrap.GatewayBrokerTransportStep;
import io.camunda.zeebe.broker.client.api.BrokerClient;
import io.camunda.zeebe.broker.clustering.ClusterServicesImpl;
import io.camunda.zeebe.broker.exporter.repo.ExporterRepository;
import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.broker.system.monitoring.BrokerHealthCheckService;
import io.camunda.zeebe.protocol.impl.encoding.BrokerInfo;
import io.camunda.zeebe.scheduler.Actor;
import io.camunda.zeebe.scheduler.ActorScheduler;
import io.camunda.zeebe.scheduler.ActorSchedulingService;
import io.camunda.zeebe.scheduler.ConcurrencyControl;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.testing.TestConcurrencyControl;
import io.camunda.zeebe.transport.impl.AtomixServerTransport;
import java.time.Duration;
import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

class GatewayBrokerTransportStepTest {
    private static final Duration TEST_SHUTDOWN_TIMEOUT = Duration.ofSeconds(10L);
    private static final TestConcurrencyControl CONCURRENCY_CONTROL = new TestConcurrencyControl();
    private static final BrokerCfg TEST_BROKER_CONFIG = new BrokerCfg();
    private static final BrokerInfo TEST_BROKER_INFO = new BrokerInfo(0, "localhost");
    private static final Duration TIME_OUT = Duration.ofSeconds(10L);
    private final ActorScheduler mockActorSchedulingService = (ActorScheduler)Mockito.mock(ActorScheduler.class);
    private BrokerStartupContextImpl testBrokerStartupContext;
    private final GatewayBrokerTransportStep sut = new GatewayBrokerTransportStep();

    GatewayBrokerTransportStepTest() {
    }

    @BeforeEach
    void setUp() {
        Mockito.when((Object)this.mockActorSchedulingService.submitActor((Actor)ArgumentMatchers.any())).thenReturn((Object)CONCURRENCY_CONTROL.completedFuture(null));
        this.testBrokerStartupContext = new BrokerStartupContextImpl(TEST_BROKER_INFO, TEST_BROKER_CONFIG, (SpringBrokerBridge)Mockito.mock(SpringBrokerBridge.class), (ActorSchedulingService)this.mockActorSchedulingService, (BrokerHealthCheckService)Mockito.mock(BrokerHealthCheckService.class), (ExporterRepository)Mockito.mock(ExporterRepository.class), (ClusterServicesImpl)Mockito.mock(ClusterServicesImpl.class, (Answer)Mockito.RETURNS_DEEP_STUBS), (BrokerClient)Mockito.mock(BrokerClient.class), Collections.emptyList(), TEST_SHUTDOWN_TIMEOUT);
        this.testBrokerStartupContext.setConcurrencyControl((ConcurrencyControl)CONCURRENCY_CONTROL);
    }

    @Test
    void shouldHaveDescriptiveName() {
        String actual = this.sut.getName();
        Assertions.assertThat((String)actual).isSameAs((Object)"Broker Transport");
    }

    @Nested
    class ShutdownBehavior {
        private AtomixServerTransport mockTransport;
        private ActorFuture<BrokerStartupContext> shutdownFuture;

        ShutdownBehavior() {
        }

        @BeforeEach
        void setUp() {
            this.mockTransport = (AtomixServerTransport)Mockito.mock(AtomixServerTransport.class);
            Mockito.when((Object)this.mockTransport.closeAsync()).thenReturn((Object)CONCURRENCY_CONTROL.completedFuture(null));
            GatewayBrokerTransportStepTest.this.testBrokerStartupContext.setGatewayBrokerTransport(this.mockTransport);
            this.shutdownFuture = CONCURRENCY_CONTROL.createFuture();
        }

        @Test
        void shouldStopAndUninstallServerTransport() {
            GatewayBrokerTransportStepTest.this.sut.shutdownInternal((BrokerStartupContext)GatewayBrokerTransportStepTest.this.testBrokerStartupContext, (ConcurrencyControl)CONCURRENCY_CONTROL, this.shutdownFuture);
            Awaitility.await().until(() -> this.shutdownFuture.isDone());
            ((AtomixServerTransport)Mockito.verify((Object)this.mockTransport)).closeAsync();
            AtomixServerTransport serverTransport = GatewayBrokerTransportStepTest.this.testBrokerStartupContext.getGatewayBrokerTransport();
            Assertions.assertThat((Object)serverTransport).isNull();
        }

        @Test
        void shouldCompleteFuture() {
            GatewayBrokerTransportStepTest.this.sut.shutdownInternal((BrokerStartupContext)GatewayBrokerTransportStepTest.this.testBrokerStartupContext, (ConcurrencyControl)CONCURRENCY_CONTROL, this.shutdownFuture);
            Assertions.assertThat(this.shutdownFuture).succeedsWithin(TIME_OUT);
            Assertions.assertThat((Object)((BrokerStartupContext)this.shutdownFuture.join())).isNotNull();
        }
    }

    @Nested
    class StartupBehavior {
        private ActorFuture<BrokerStartupContext> startupFuture;

        StartupBehavior() {
        }

        @BeforeEach
        void setUp() {
            this.startupFuture = CONCURRENCY_CONTROL.createFuture();
        }

        @Test
        void shouldCompleteFuture() {
            GatewayBrokerTransportStepTest.this.sut.startupInternal((BrokerStartupContext)GatewayBrokerTransportStepTest.this.testBrokerStartupContext, (ConcurrencyControl)CONCURRENCY_CONTROL, this.startupFuture);
            Assertions.assertThat(this.startupFuture).succeedsWithin(TIME_OUT);
            Assertions.assertThat((Object)((BrokerStartupContext)this.startupFuture.join())).isNotNull();
        }

        @Test
        void shouldStartAndInstallTransport() {
            GatewayBrokerTransportStepTest.this.sut.startupInternal((BrokerStartupContext)GatewayBrokerTransportStepTest.this.testBrokerStartupContext, (ConcurrencyControl)CONCURRENCY_CONTROL, this.startupFuture);
            Awaitility.await().until(() -> this.startupFuture.isDone());
            AtomixServerTransport transport = GatewayBrokerTransportStepTest.this.testBrokerStartupContext.getGatewayBrokerTransport();
            Assertions.assertThat((Object)transport).isNotNull();
            ((ActorScheduler)Mockito.verify((Object)GatewayBrokerTransportStepTest.this.mockActorSchedulingService)).submitActor((Actor)transport);
        }
    }
}

