/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.bootstrap;

import io.camunda.zeebe.broker.bootstrap.JobStreamServiceStep;
import io.camunda.zeebe.msgpack.value.StringValue;
import io.camunda.zeebe.protocol.impl.stream.job.JobActivationProperties;
import io.camunda.zeebe.protocol.impl.stream.job.JobActivationPropertiesImpl;
import io.camunda.zeebe.util.buffer.BufferUtil;
import io.camunda.zeebe.util.buffer.BufferWriter;
import java.util.Collection;
import java.util.List;
import org.agrona.DirectBuffer;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

final class JobStreamServiceStepTest {
    JobStreamServiceStepTest() {
    }

    @Nested
    final class ImmutableJobActivationPropertiesTest {
        ImmutableJobActivationPropertiesTest(JobStreamServiceStepTest this$0) {
        }

        @Test
        void shouldDeserializeImmutableActivationProperties() {
            DirectBuffer worker = BufferUtil.wrapString((String)"worker");
            JobActivationPropertiesImpl properties = new JobActivationPropertiesImpl().setTimeout(250L).setFetchVariables(List.of(new StringValue("foo"), new StringValue("bar"))).setWorker(worker, 0, worker.capacity()).setTenantIds(List.of("tenant1", "tenant2"));
            DirectBuffer buffer = BufferUtil.createCopy((BufferWriter)properties);
            JobActivationProperties immutable = JobStreamServiceStep.readJobActivationProperties((DirectBuffer)buffer);
            ((AbstractComparableAssert)Assertions.assertThat((Comparable)immutable.worker()).isEqualTo((Object)worker)).isNotSameAs((Object)worker);
            Assertions.assertThat((long)immutable.timeout()).isEqualTo(250L);
            Assertions.assertThat((Collection)immutable.fetchVariables()).containsExactlyInAnyOrder((Object[])new DirectBuffer[]{BufferUtil.wrapString((String)"foo"), BufferUtil.wrapString((String)"bar")});
            Assertions.assertThat((Collection)immutable.tenantIds()).containsExactlyInAnyOrder((Object[])new String[]{"tenant1", "tenant2"});
        }
    }
}

