/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.bootstrap;

import io.camunda.zeebe.broker.PartitionRaftListener;
import io.camunda.zeebe.broker.SpringBrokerBridge;
import io.camunda.zeebe.broker.bootstrap.BrokerStartupContext;
import io.camunda.zeebe.broker.bootstrap.MonitoringServerStep;
import io.camunda.zeebe.broker.system.monitoring.BrokerHealthCheckService;
import io.camunda.zeebe.scheduler.Actor;
import io.camunda.zeebe.scheduler.ActorSchedulingService;
import io.camunda.zeebe.scheduler.ConcurrencyControl;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.testing.TestConcurrencyControl;
import java.time.Duration;
import java.util.function.Supplier;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

class MonitoringServerStepTest {
    private static final TestConcurrencyControl CONCURRENCY_CONTROL = new TestConcurrencyControl();
    private static final Duration TIME_OUT = Duration.ofSeconds(10L);
    private SpringBrokerBridge mockSpringBrokerBridge;
    private BrokerStartupContext mockBrokerStartupContext;
    private BrokerHealthCheckService mockHealthCheckService;
    private ActorSchedulingService mockActorSchedulingService;
    private ActorFuture<BrokerStartupContext> future;
    private final MonitoringServerStep sut = new MonitoringServerStep();

    MonitoringServerStepTest() {
    }

    @BeforeEach
    void setUp() {
        this.mockSpringBrokerBridge = (SpringBrokerBridge)Mockito.mock(SpringBrokerBridge.class);
        this.mockBrokerStartupContext = (BrokerStartupContext)Mockito.mock(BrokerStartupContext.class);
        this.mockActorSchedulingService = (ActorSchedulingService)Mockito.mock(ActorSchedulingService.class);
        this.mockHealthCheckService = (BrokerHealthCheckService)Mockito.mock(BrokerHealthCheckService.class);
        Mockito.when((Object)this.mockHealthCheckService.closeAsync()).thenReturn((Object)CONCURRENCY_CONTROL.completedFuture(null));
        Mockito.when((Object)this.mockBrokerStartupContext.getConcurrencyControl()).thenReturn((Object)CONCURRENCY_CONTROL);
        Mockito.when((Object)this.mockBrokerStartupContext.getSpringBrokerBridge()).thenReturn((Object)this.mockSpringBrokerBridge);
        Mockito.when((Object)this.mockBrokerStartupContext.getHealthCheckService()).thenReturn((Object)this.mockHealthCheckService);
        Mockito.when((Object)this.mockBrokerStartupContext.getActorSchedulingService()).thenReturn((Object)this.mockActorSchedulingService);
        Mockito.when((Object)this.mockActorSchedulingService.submitActor((Actor)ArgumentMatchers.any())).thenReturn((Object)CONCURRENCY_CONTROL.completedFuture(null));
        this.future = CONCURRENCY_CONTROL.createFuture();
    }

    @Test
    void shouldCompleteFutureOnStartup() {
        this.sut.startupInternal(this.mockBrokerStartupContext, (ConcurrencyControl)CONCURRENCY_CONTROL, this.future);
        Assertions.assertThat(this.future).succeedsWithin(TIME_OUT);
        Assertions.assertThat((Object)((BrokerStartupContext)this.future.join())).isNotNull();
    }

    @Test
    void shouldScheduleHealthMonitorActorOnStartup() {
        this.sut.startupInternal(this.mockBrokerStartupContext, (ConcurrencyControl)CONCURRENCY_CONTROL, this.future);
        Awaitility.await().until(() -> this.future.isDone());
        ((ActorSchedulingService)Mockito.verify((Object)this.mockActorSchedulingService)).submitActor((Actor)this.mockHealthCheckService);
    }

    @Test
    void shouldRegisterHealthMonitorAsPartitionListenerOnStartup() {
        this.sut.startupInternal(this.mockBrokerStartupContext, (ConcurrencyControl)CONCURRENCY_CONTROL, this.future);
        Awaitility.await().until(() -> this.future.isDone());
        ((BrokerStartupContext)Mockito.verify((Object)this.mockBrokerStartupContext)).addPartitionRaftListener((PartitionRaftListener)this.mockHealthCheckService);
    }

    @Test
    void shouldRegisterHealthMonitorInSpringBrokerBridgeOnStartup() {
        this.sut.startupInternal(this.mockBrokerStartupContext, (ConcurrencyControl)CONCURRENCY_CONTROL, this.future);
        Awaitility.await().until(() -> this.future.isDone());
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(Supplier.class);
        ((SpringBrokerBridge)Mockito.verify((Object)this.mockSpringBrokerBridge)).registerBrokerHealthCheckServiceSupplier((Supplier)argumentCaptor.capture());
        Assertions.assertThat(((Supplier)argumentCaptor.getValue()).get()).isSameAs((Object)this.mockHealthCheckService);
    }

    @Test
    void shouldCompleteFutureOnShutdown() {
        this.sut.shutdownInternal(this.mockBrokerStartupContext, (ConcurrencyControl)CONCURRENCY_CONTROL, this.future);
        Assertions.assertThat(this.future).succeedsWithin(TIME_OUT);
        Assertions.assertThat((Object)((BrokerStartupContext)this.future.join())).isNotNull();
    }

    @Test
    void shouldStopHealthCheckServiceOnShutdown() {
        this.sut.shutdownInternal(this.mockBrokerStartupContext, (ConcurrencyControl)CONCURRENCY_CONTROL, this.future);
        Awaitility.await().until(() -> this.future.isDone());
        ((BrokerHealthCheckService)Mockito.verify((Object)this.mockHealthCheckService)).closeAsync();
    }

    @Test
    void shouldUnregisterHealthCheckServiceAsPartitionListenerOnShutdown() {
        this.sut.shutdownInternal(this.mockBrokerStartupContext, (ConcurrencyControl)CONCURRENCY_CONTROL, this.future);
        Awaitility.await().until(() -> this.future.isDone());
        ((BrokerStartupContext)Mockito.verify((Object)this.mockBrokerStartupContext)).removePartitionRaftListener((PartitionRaftListener)this.mockHealthCheckService);
    }

    @Test
    void shouldUnregisterHealthMonitorInSpringBrokerBridgeOnStartup() {
        this.sut.shutdownInternal(this.mockBrokerStartupContext, (ConcurrencyControl)CONCURRENCY_CONTROL, this.future);
        Awaitility.await().until(() -> this.future.isDone());
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(Supplier.class);
        ((SpringBrokerBridge)Mockito.verify((Object)this.mockSpringBrokerBridge)).registerBrokerHealthCheckServiceSupplier((Supplier)argumentCaptor.capture());
        Assertions.assertThat(((Supplier)argumentCaptor.getValue()).get()).isNull();
    }
}

