/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.bootstrap;

import io.atomix.cluster.ClusterMembershipService;
import io.atomix.cluster.Member;
import io.atomix.cluster.MemberConfig;
import io.camunda.zeebe.broker.SpringBrokerBridge;
import io.camunda.zeebe.broker.bootstrap.BrokerStartupContext;
import io.camunda.zeebe.broker.bootstrap.BrokerStartupContextImpl;
import io.camunda.zeebe.broker.bootstrap.PartitionManagerStep;
import io.camunda.zeebe.broker.client.api.BrokerClient;
import io.camunda.zeebe.broker.clustering.ClusterServicesImpl;
import io.camunda.zeebe.broker.exporter.repo.ExporterRepository;
import io.camunda.zeebe.broker.jobstream.JobStreamService;
import io.camunda.zeebe.broker.partitioning.PartitionManagerImpl;
import io.camunda.zeebe.broker.partitioning.topology.ClusterTopologyService;
import io.camunda.zeebe.broker.partitioning.topology.PartitionDistribution;
import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.broker.system.management.BrokerAdminServiceImpl;
import io.camunda.zeebe.broker.system.monitoring.BrokerHealthCheckService;
import io.camunda.zeebe.broker.transport.adminapi.AdminApiRequestHandler;
import io.camunda.zeebe.gateway.impl.configuration.NetworkCfg;
import io.camunda.zeebe.protocol.impl.encoding.BrokerInfo;
import io.camunda.zeebe.scheduler.ActorScheduler;
import io.camunda.zeebe.scheduler.ActorSchedulingService;
import io.camunda.zeebe.scheduler.ConcurrencyControl;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.future.CompletableActorFuture;
import io.camunda.zeebe.scheduler.testing.TestConcurrencyControl;
import io.camunda.zeebe.test.util.socket.SocketUtil;
import java.time.Duration;
import java.util.Collections;
import java.util.concurrent.ExecutionException;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PartitionManagerStepTest {
    public static final Duration TEST_SHUTDOWN_TIMEOUT = Duration.ofSeconds(10L);
    private static final TestConcurrencyControl CONCURRENCY_CONTROL = new TestConcurrencyControl();
    private static final BrokerCfg TEST_BROKER_CONFIG = new BrokerCfg();
    private static final Duration TIME_OUT = Duration.ofSeconds(10L);
    private final Logger log = LoggerFactory.getLogger(PartitionManagerStepTest.class);
    private final PartitionManagerStep sut = new PartitionManagerStep();
    private BrokerStartupContextImpl testBrokerStartupContext;

    PartitionManagerStepTest() {
    }

    @Test
    void shouldHaveDescriptiveName() {
        String actual = this.sut.getName();
        Assertions.assertThat((String)actual).isSameAs((Object)"Partition Manager");
    }

    static {
        NetworkCfg networkCfg = TEST_BROKER_CONFIG.getGateway().getNetwork();
        networkCfg.setHost("localhost");
    }

    @Nested
    class ShutdownBehavior {
        private PartitionManagerImpl mockPartitionManager;
        private ActorFuture<BrokerStartupContext> shutdownFuture;

        ShutdownBehavior() {
        }

        @BeforeEach
        void setUp() {
            this.mockPartitionManager = (PartitionManagerImpl)Mockito.mock(PartitionManagerImpl.class);
            Mockito.when((Object)this.mockPartitionManager.stop()).thenReturn((Object)CompletableActorFuture.completed(null));
            PartitionManagerStepTest.this.testBrokerStartupContext = new BrokerStartupContextImpl((BrokerInfo)Mockito.mock(BrokerInfo.class), TEST_BROKER_CONFIG, (SpringBrokerBridge)Mockito.mock(SpringBrokerBridge.class), (ActorSchedulingService)Mockito.mock(ActorScheduler.class), (BrokerHealthCheckService)Mockito.mock(BrokerHealthCheckService.class), (ExporterRepository)Mockito.mock(ExporterRepository.class), (ClusterServicesImpl)Mockito.mock(ClusterServicesImpl.class, (Answer)Mockito.RETURNS_DEEP_STUBS), (BrokerClient)Mockito.mock(BrokerClient.class), Collections.emptyList(), TEST_SHUTDOWN_TIMEOUT);
            PartitionManagerStepTest.this.testBrokerStartupContext.setPartitionManager(this.mockPartitionManager);
            ClusterTopologyService mockClusterTopology = (ClusterTopologyService)Mockito.mock(ClusterTopologyService.class);
            PartitionManagerStepTest.this.testBrokerStartupContext.setClusterTopology(mockClusterTopology);
            this.shutdownFuture = CONCURRENCY_CONTROL.createFuture();
        }

        @Test
        void shouldStopAndUninstallEmbeddedGateway() {
            PartitionManagerStepTest.this.sut.shutdownInternal((BrokerStartupContext)PartitionManagerStepTest.this.testBrokerStartupContext, (ConcurrencyControl)CONCURRENCY_CONTROL, this.shutdownFuture);
            Awaitility.await().until(() -> this.shutdownFuture.isDone());
            ((PartitionManagerImpl)Mockito.verify((Object)this.mockPartitionManager)).stop();
            PartitionManagerImpl partitionManager = PartitionManagerStepTest.this.testBrokerStartupContext.getPartitionManager();
            Assertions.assertThat((Object)partitionManager).isNull();
        }

        @Test
        void shouldCompleteFuture() {
            PartitionManagerStepTest.this.sut.shutdownInternal((BrokerStartupContext)PartitionManagerStepTest.this.testBrokerStartupContext, (ConcurrencyControl)CONCURRENCY_CONTROL, this.shutdownFuture);
            Assertions.assertThat(this.shutdownFuture).succeedsWithin(TIME_OUT);
            Assertions.assertThat((Object)((BrokerStartupContext)this.shutdownFuture.join())).isNotNull();
        }
    }

    @Nested
    class StartupBehavior {
        private ActorFuture<BrokerStartupContext> startupFuture;
        private ActorScheduler actorScheduler;

        StartupBehavior() {
        }

        @BeforeEach
        void setUp() {
            this.actorScheduler = ActorScheduler.newActorScheduler().build();
            this.actorScheduler.start();
            this.startupFuture = CONCURRENCY_CONTROL.createFuture();
            PartitionManagerStepTest.this.testBrokerStartupContext = new BrokerStartupContextImpl((BrokerInfo)Mockito.mock(BrokerInfo.class), TEST_BROKER_CONFIG, (SpringBrokerBridge)Mockito.mock(SpringBrokerBridge.class), (ActorSchedulingService)this.actorScheduler, (BrokerHealthCheckService)Mockito.mock(BrokerHealthCheckService.class), (ExporterRepository)Mockito.mock(ExporterRepository.class), (ClusterServicesImpl)Mockito.mock(ClusterServicesImpl.class, (Answer)Mockito.RETURNS_DEEP_STUBS), (BrokerClient)Mockito.mock(BrokerClient.class), Collections.emptyList(), TEST_SHUTDOWN_TIMEOUT);
            PartitionManagerStepTest.this.testBrokerStartupContext.setConcurrencyControl((ConcurrencyControl)CONCURRENCY_CONTROL);
            PartitionManagerStepTest.this.testBrokerStartupContext.setAdminApiService((AdminApiRequestHandler)Mockito.mock(AdminApiRequestHandler.class));
            PartitionManagerStepTest.this.testBrokerStartupContext.setBrokerAdminService((BrokerAdminServiceImpl)Mockito.mock(BrokerAdminServiceImpl.class));
            PartitionManagerStepTest.this.testBrokerStartupContext.setJobStreamService((JobStreamService)Mockito.mock(JobStreamService.class));
            ClusterTopologyService mockClusterTopology = (ClusterTopologyService)Mockito.mock(ClusterTopologyService.class);
            Mockito.when((Object)mockClusterTopology.getPartitionDistribution()).thenReturn((Object)PartitionDistribution.NO_PARTITIONS);
            PartitionManagerStepTest.this.testBrokerStartupContext.setClusterTopology(mockClusterTopology);
            MemberConfig memberConfig = new MemberConfig();
            Member member = new Member(memberConfig);
            ClusterMembershipService mockMembershipService = (ClusterMembershipService)Mockito.mock(ClusterMembershipService.class);
            Mockito.when((Object)mockMembershipService.getLocalMember()).thenReturn((Object)member);
            Mockito.when((Object)PartitionManagerStepTest.this.testBrokerStartupContext.getClusterServices().getMembershipService()).thenReturn((Object)mockMembershipService);
            int port = SocketUtil.getNextAddress().getPort();
            NetworkCfg commandApiCfg = TEST_BROKER_CONFIG.getGateway().getNetwork();
            commandApiCfg.setPort(port);
        }

        @AfterEach
        void tearDown() {
            PartitionManagerImpl partitionManager = PartitionManagerStepTest.this.testBrokerStartupContext.getPartitionManager();
            if (partitionManager != null) {
                partitionManager.stop().join();
            }
            try {
                this.actorScheduler.stop();
            }
            catch (IllegalStateException e) {
                PartitionManagerStepTest.this.log.debug("ActorScheduler was already stopped.");
            }
        }

        @Test
        void shouldCompleteFuture() {
            PartitionManagerStepTest.this.sut.startupInternal((BrokerStartupContext)PartitionManagerStepTest.this.testBrokerStartupContext, (ConcurrencyControl)CONCURRENCY_CONTROL, this.startupFuture);
            Assertions.assertThat(this.startupFuture).succeedsWithin(TIME_OUT);
            Assertions.assertThat((Object)((BrokerStartupContext)this.startupFuture.join())).isNotNull();
        }

        @Test
        void shouldStartAndInstallEmbeddedGatewayService() {
            PartitionManagerStepTest.this.sut.startupInternal((BrokerStartupContext)PartitionManagerStepTest.this.testBrokerStartupContext, (ConcurrencyControl)CONCURRENCY_CONTROL, this.startupFuture);
            Awaitility.await().until(() -> this.startupFuture.isDone());
            PartitionManagerImpl partitionManager = PartitionManagerStepTest.this.testBrokerStartupContext.getPartitionManager();
            Assertions.assertThat((Object)partitionManager).isNotNull();
        }

        @Test
        void shouldHandleSyncFailOfStart() throws Exception {
            this.actorScheduler.close();
            PartitionManagerStepTest.this.sut.startupInternal((BrokerStartupContext)PartitionManagerStepTest.this.testBrokerStartupContext, (ConcurrencyControl)CONCURRENCY_CONTROL, this.startupFuture);
            Assertions.assertThat(this.startupFuture).failsWithin(Duration.ZERO).withThrowableOfType(ExecutionException.class).withRootCauseInstanceOf(IllegalStateException.class);
        }
    }
}

