/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.engine;

import io.camunda.zeebe.broker.test.EmbeddedBrokerRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.DeploymentIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceCreationIntent;
import io.camunda.zeebe.test.broker.protocol.commandapi.CommandApiRule;
import io.camunda.zeebe.test.broker.protocol.commandapi.ExecuteCommandRequestBuilder;
import io.camunda.zeebe.test.broker.protocol.commandapi.ExecuteCommandResponse;
import io.camunda.zeebe.test.util.BrokerClassRuleHelper;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.util.VersionUtil;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public final class RecordVersionTest {
    private static final String PROCESS_ID = "process";
    private static final String EXPECTED_VERSION = VersionUtil.getVersion().replaceAll("-SNAPSHOT", "");
    private static final EmbeddedBrokerRule BROKER_RULE = new EmbeddedBrokerRule(new Consumer[0]);
    private static final CommandApiRule API_RULE = new CommandApiRule(BROKER_RULE::getAtomixCluster);
    @ClassRule
    public static RuleChain ruleChain = RuleChain.outerRule((TestRule)BROKER_RULE).around((TestRule)API_RULE);
    @Rule
    public final BrokerClassRuleHelper helper = new BrokerClassRuleHelper();

    @Test
    public void deploymentRecordsShouldHaveBrokerVersion() {
        BpmnModelInstance process = Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().endEvent().done();
        this.deployProcess(process);
        ((ListAssert)Assertions.assertThat((Stream)RecordingExporter.processRecords().limit(1L)).hasSize(1)).extracting(Record::getBrokerVersion).containsOnly((Object[])new String[]{EXPECTED_VERSION});
        ((ListAssert)Assertions.assertThat((Stream)RecordingExporter.deploymentRecords().limit(2L)).hasSize(2)).extracting(Record::getBrokerVersion).containsOnly((Object[])new String[]{EXPECTED_VERSION});
    }

    @Test
    public void processInstanceRecordsShouldHaveBrokerVersion() {
        BpmnModelInstance process = Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().endEvent().done();
        this.deployProcess(process);
        long processInstanceKey = this.createProcessInstance(PROCESS_ID);
        Assertions.assertThat((Stream)RecordingExporter.records().betweenProcessInstance(processInstanceKey)).extracting(Record::getBrokerVersion).containsOnly((Object[])new String[]{EXPECTED_VERSION});
    }

    @Test
    public void messageSubscriptionRecordsShouldHaveBrokerVersion() {
        BpmnModelInstance process = Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().intermediateCatchEvent("catch", e -> e.message(m -> m.name("test").zeebeCorrelationKeyExpression("123"))).endEvent().done();
        this.deployProcess(process);
        long processInstanceKey = this.createProcessInstance(PROCESS_ID);
        ((ListAssert)Assertions.assertThat((Stream)RecordingExporter.messageSubscriptionRecords().withProcessInstanceKey(processInstanceKey).limit(2L)).hasSize(2)).extracting(Record::getBrokerVersion).containsOnly((Object[])new String[]{EXPECTED_VERSION});
        ((ListAssert)Assertions.assertThat((Stream)RecordingExporter.processMessageSubscriptionRecords().withProcessInstanceKey(processInstanceKey).limit(2L)).hasSize(2)).extracting(Record::getBrokerVersion).containsOnly((Object[])new String[]{EXPECTED_VERSION});
    }

    private void deployProcess(BpmnModelInstance process) {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        Bpmn.writeModelToStream((OutputStream)outStream, (BpmnModelInstance)process);
        byte[] resource = outStream.toByteArray();
        ((ExecuteCommandRequestBuilder)API_RULE.createCmdRequest().type(ValueType.DEPLOYMENT, (Intent)DeploymentIntent.CREATE).command().put("resources", List.of(Map.of("resourceName", "process.bpmn", "resource", resource))).done()).send();
    }

    private long createProcessInstance(String processId) {
        ExecuteCommandResponse response = ((ExecuteCommandRequestBuilder)API_RULE.createCmdRequest().type(ValueType.PROCESS_INSTANCE_CREATION, (Intent)ProcessInstanceCreationIntent.CREATE).command().put("bpmnProcessId", (Object)processId).done()).sendAndAwait();
        return (Long)response.getValue().get("processInstanceKey");
    }
}

