/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.engine;

import io.camunda.zeebe.broker.test.EmbeddedBrokerRule;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.MessageIntent;
import io.camunda.zeebe.test.broker.protocol.commandapi.CommandApiRule;
import io.camunda.zeebe.test.broker.protocol.commandapi.ExecuteCommandRequestBuilder;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public final class RejectIncompleteCommandsTest {
    private static final EmbeddedBrokerRule BROKER_RULE = new EmbeddedBrokerRule(new Consumer[0]);
    private static final CommandApiRule API_RULE = new CommandApiRule(BROKER_RULE::getAtomixCluster);
    @ClassRule
    public static RuleChain ruleChain = RuleChain.outerRule((TestRule)BROKER_RULE).around((TestRule)API_RULE);

    @Test
    public void shouldFailToPublishMessageWithoutName() {
        ExecuteCommandRequestBuilder request = (ExecuteCommandRequestBuilder)API_RULE.createCmdRequest().type(ValueType.MESSAGE, (Intent)MessageIntent.PUBLISH).command().put("correlationKey", (Object)"order-123").put("timeToLive", (Object)1000).done();
        Assertions.assertThatThrownBy(() -> ((ExecuteCommandRequestBuilder)request).sendAndAwait()).hasMessageContaining("Property 'name' has no valid value");
    }

    @Test
    public void shouldFailToPublishMessageWithoutCorrelationKey() {
        ExecuteCommandRequestBuilder request = (ExecuteCommandRequestBuilder)API_RULE.createCmdRequest().type(ValueType.MESSAGE, (Intent)MessageIntent.PUBLISH).command().put("name", (Object)"order canceled").put("timeToLive", (Object)1000).done();
        Assertions.assertThatThrownBy(() -> ((ExecuteCommandRequestBuilder)request).sendAndAwait()).hasMessageContaining("Property 'correlationKey' has no valid value");
    }

    @Test
    public void shouldFailToPublishMessageWithoutTimeToLive() {
        ExecuteCommandRequestBuilder request = (ExecuteCommandRequestBuilder)API_RULE.createCmdRequest().type(ValueType.MESSAGE, (Intent)MessageIntent.PUBLISH).command().put("name", (Object)"order canceled").put("correlationKey", (Object)"order-123").done();
        Assertions.assertThatThrownBy(() -> request.sendAndAwait()).hasMessageContaining("Property 'timeToLive' has no valid value");
    }
}

