/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.engine.impl;

import io.camunda.zeebe.broker.engine.impl.ScheduledCommandCacheMetrics;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.util.function.IntConsumer;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

final class BoundedCommandCacheMetricsTest {
    BoundedCommandCacheMetricsTest() {
    }

    @Test
    void shouldReportSizeForIntent() {
        SimpleMeterRegistry registry = new SimpleMeterRegistry();
        ScheduledCommandCacheMetrics.BoundedCommandCacheMetrics metrics = new ScheduledCommandCacheMetrics.BoundedCommandCacheMetrics((MeterRegistry)registry);
        IntConsumer timeout = metrics.forIntent((Intent)JobIntent.TIME_OUT);
        IntConsumer recur = metrics.forIntent((Intent)JobIntent.RECUR_AFTER_BACKOFF);
        timeout.accept(10);
        recur.accept(20);
        timeout.accept(30);
        Gauge timeoutGauge = registry.get("zeebe.stream.processor.scheduled.command.cache.size").tag("intent", "JobIntent.TIME_OUT").gauge();
        Gauge recurGauge = registry.get("zeebe.stream.processor.scheduled.command.cache.size").tag("intent", "JobIntent.RECUR_AFTER_BACKOFF").gauge();
        Assertions.assertThat((Object)timeoutGauge).returns((Object)30.0, Gauge::value);
        Assertions.assertThat((Object)recurGauge).returns((Object)20.0, Gauge::value);
    }
}

