/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.engine.impl;

import io.camunda.zeebe.broker.engine.impl.BoundedCommandCache;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.agrona.collections.LongHashSet;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

final class BoundedCommandCacheTest {
    BoundedCommandCacheTest() {
    }

    @Test
    void shouldNotExceedCapacity() {
        BoundedCommandCache cache = new BoundedCommandCache(4);
        cache.add(this.setOf(1L, 2L, 3L, 4L));
        cache.add(this.setOf(5L, 6L));
        Assertions.assertThat((int)cache.size()).isEqualTo(4);
        Assertions.assertThat((boolean)cache.contains(5L)).isTrue();
        Assertions.assertThat((boolean)cache.contains(6L)).isTrue();
    }

    @Test
    void shouldEvictRandomKeysOnCapacityReached() {
        BoundedCommandCache cache = new BoundedCommandCache(4);
        LongHashSet initialKeys = this.setOf(1L, 2L, 3L, 4L);
        cache.add(initialKeys);
        cache.add(this.setOf(5L, 6L));
        Set remainingInitialKeys = initialKeys.stream().filter(arg_0 -> ((BoundedCommandCache)cache).contains(arg_0)).collect(Collectors.toSet());
        ((AbstractCollectionAssert)Assertions.assertThat(remainingInitialKeys).hasSize(2)).containsAnyElementsOf((Iterable)initialKeys);
    }

    @Test
    void shouldReportSizeChanges() {
        AtomicInteger reportedSize = new AtomicInteger();
        BoundedCommandCache cache = new BoundedCommandCache(reportedSize::set);
        cache.add(this.setOf(1L, 2L, 3L, 4L));
        Assertions.assertThat((AtomicInteger)reportedSize).hasValue(4);
        cache.remove(1L);
        Assertions.assertThat((AtomicInteger)reportedSize).hasValue(3);
    }

    @Test
    void shouldReportSizeToResetMetricOnCreation() {
        AtomicInteger reportedSize = new AtomicInteger(200);
        BoundedCommandCache ignored = new BoundedCommandCache(reportedSize::set);
        Assertions.assertThat((AtomicInteger)reportedSize).hasValue(0);
    }

    @Test
    void shouldClearCache() {
        AtomicInteger reportedSize = new AtomicInteger();
        BoundedCommandCache cache = new BoundedCommandCache(reportedSize::set);
        cache.add(this.setOf(1L, 2L, 3L, 4L));
        cache.clear();
        Assertions.assertThat((int)cache.size()).isZero();
        Assertions.assertThat((AtomicInteger)reportedSize).hasValue(0);
    }

    private LongHashSet setOf(long ... keys) {
        LongHashSet set = new LongHashSet();
        set.addAll(Arrays.stream(keys).boxed().toList());
        return set;
    }
}

