/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.engine.impl;

import io.camunda.zeebe.broker.engine.impl.BoundedScheduledCommandCache;
import io.camunda.zeebe.broker.engine.impl.ScheduledCommandCacheMetrics;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.protocol.record.intent.TimerIntent;
import io.camunda.zeebe.stream.api.scheduling.ScheduledCommandCache;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

final class BoundedScheduledCommandCacheTest {
    private static final ScheduledCommandCacheMetrics NOOP_METRICS = ignored -> i -> {};

    BoundedScheduledCommandCacheTest() {
    }

    @Test
    void shouldNotCacheUnknownIntents() {
        BoundedScheduledCommandCache cache = BoundedScheduledCommandCache.ofIntent((ScheduledCommandCacheMetrics)NOOP_METRICS, (Intent[])new Intent[]{TimerIntent.TRIGGER});
        cache.add((Intent)JobIntent.TIME_OUT, 1L);
        Assertions.assertThat((boolean)cache.contains((Intent)JobIntent.TIME_OUT, 1L)).isFalse();
    }

    @Test
    void shouldAdd() {
        BoundedScheduledCommandCache cache = BoundedScheduledCommandCache.ofIntent((ScheduledCommandCacheMetrics)NOOP_METRICS, (Intent[])new Intent[]{TimerIntent.TRIGGER});
        cache.add((Intent)TimerIntent.TRIGGER, 1L);
        Assertions.assertThat((boolean)cache.contains((Intent)TimerIntent.TRIGGER, 1L)).isTrue();
    }

    @Test
    void shouldNotContainNonCachedKeyIntentPairWithSameIntent() {
        BoundedScheduledCommandCache cache = BoundedScheduledCommandCache.ofIntent((ScheduledCommandCacheMetrics)NOOP_METRICS, (Intent[])new Intent[]{TimerIntent.TRIGGER});
        cache.add((Intent)TimerIntent.TRIGGER, 1L);
        Assertions.assertThat((boolean)cache.contains((Intent)TimerIntent.TRIGGER, 2L)).isFalse();
    }

    @Test
    void shouldNotContainNonCachedKeyIntentPairWithSameKey() {
        BoundedScheduledCommandCache cache = BoundedScheduledCommandCache.ofIntent((ScheduledCommandCacheMetrics)NOOP_METRICS, (Intent[])new Intent[]{TimerIntent.TRIGGER, JobIntent.TIME_OUT});
        cache.add((Intent)JobIntent.TIME_OUT, 1L);
        Assertions.assertThat((boolean)cache.contains((Intent)TimerIntent.TRIGGER, 1L)).isFalse();
    }

    @Test
    void shouldRemoveCachedIntentKeyPair() {
        BoundedScheduledCommandCache cache = BoundedScheduledCommandCache.ofIntent((ScheduledCommandCacheMetrics)NOOP_METRICS, (Intent[])new Intent[]{TimerIntent.TRIGGER, JobIntent.TIME_OUT});
        cache.add((Intent)JobIntent.TIME_OUT, 1L);
        cache.add((Intent)TimerIntent.TRIGGER, 1L);
        cache.remove((Intent)JobIntent.TIME_OUT, 1L);
        Assertions.assertThat((boolean)cache.contains((Intent)JobIntent.TIME_OUT, 1L)).isFalse();
        Assertions.assertThat((boolean)cache.contains((Intent)TimerIntent.TRIGGER, 1L)).isTrue();
    }

    @Test
    void shouldReportSizePerIntent() {
        HashMap metrics = new HashMap();
        BoundedScheduledCommandCache cache = BoundedScheduledCommandCache.ofIntent(i -> metrics.computeIfAbsent(i, ignored -> new AtomicInteger())::set, (Intent[])new Intent[]{TimerIntent.TRIGGER, JobIntent.TIME_OUT});
        cache.add((Intent)JobIntent.TIME_OUT, 1L);
        cache.add((Intent)TimerIntent.TRIGGER, 1L);
        cache.add((Intent)TimerIntent.TRIGGER, 2L);
        Assertions.assertThat((AtomicInteger)((AtomicInteger)metrics.get(TimerIntent.TRIGGER))).hasValue(2);
        Assertions.assertThat((AtomicInteger)((AtomicInteger)metrics.get(JobIntent.TIME_OUT))).hasValue(1);
    }

    @Test
    void shouldClearCaches() {
        BoundedScheduledCommandCache cache = BoundedScheduledCommandCache.ofIntent((ScheduledCommandCacheMetrics)NOOP_METRICS, (Intent[])new Intent[]{TimerIntent.TRIGGER, JobIntent.TIME_OUT});
        cache.add((Intent)JobIntent.TIME_OUT, 1L);
        cache.add((Intent)TimerIntent.TRIGGER, 1L);
        cache.clear();
        Assertions.assertThat((boolean)cache.contains((Intent)JobIntent.TIME_OUT, 1L)).isFalse();
        Assertions.assertThat((boolean)cache.contains((Intent)TimerIntent.TRIGGER, 1L)).isFalse();
    }

    @Nested
    final class StagedTest {
        StagedTest(BoundedScheduledCommandCacheTest this$0) {
        }

        @Test
        void shouldNotContainStagedKeys() {
            BoundedScheduledCommandCache cache = BoundedScheduledCommandCache.ofIntent((ScheduledCommandCacheMetrics)NOOP_METRICS, (Intent[])new Intent[]{TimerIntent.TRIGGER});
            ScheduledCommandCache.StagedScheduledCommandCache staged = cache.stage();
            staged.add((Intent)TimerIntent.TRIGGER, 1L);
            Assertions.assertThat((boolean)cache.contains((Intent)TimerIntent.TRIGGER, 1L)).isFalse();
        }

        @Test
        void shouldPersistStagedKeys() {
            BoundedScheduledCommandCache cache = BoundedScheduledCommandCache.ofIntent((ScheduledCommandCacheMetrics)NOOP_METRICS, (Intent[])new Intent[]{TimerIntent.TRIGGER});
            ScheduledCommandCache.StagedScheduledCommandCache staged = cache.stage();
            staged.add((Intent)TimerIntent.TRIGGER, 1L);
            staged.persist();
            Assertions.assertThat((boolean)cache.contains((Intent)TimerIntent.TRIGGER, 1L)).isTrue();
        }

        @Test
        void shouldContainPersistedKeys() {
            BoundedScheduledCommandCache cache = BoundedScheduledCommandCache.ofIntent((ScheduledCommandCacheMetrics)NOOP_METRICS, (Intent[])new Intent[]{TimerIntent.TRIGGER});
            cache.add((Intent)TimerIntent.TRIGGER, 1L);
            ScheduledCommandCache.StagedScheduledCommandCache staged = cache.stage();
            Assertions.assertThat((boolean)staged.contains((Intent)TimerIntent.TRIGGER, 1L)).isTrue();
        }

        @Test
        void shouldContainStagedKeys() {
            BoundedScheduledCommandCache cache = BoundedScheduledCommandCache.ofIntent((ScheduledCommandCacheMetrics)NOOP_METRICS, (Intent[])new Intent[]{TimerIntent.TRIGGER});
            ScheduledCommandCache.StagedScheduledCommandCache staged = cache.stage();
            staged.add((Intent)TimerIntent.TRIGGER, 1L);
            Assertions.assertThat((boolean)cache.contains((Intent)TimerIntent.TRIGGER, 1L)).isFalse();
            Assertions.assertThat((boolean)staged.contains((Intent)TimerIntent.TRIGGER, 1L)).isTrue();
        }

        @Test
        void shouldNotRemoveFromMainCache() {
            BoundedScheduledCommandCache cache = BoundedScheduledCommandCache.ofIntent((ScheduledCommandCacheMetrics)NOOP_METRICS, (Intent[])new Intent[]{TimerIntent.TRIGGER});
            ScheduledCommandCache.StagedScheduledCommandCache staged = cache.stage();
            cache.add((Intent)TimerIntent.TRIGGER, 1L);
            staged.remove((Intent)TimerIntent.TRIGGER, 1L);
            Assertions.assertThat((boolean)cache.contains((Intent)TimerIntent.TRIGGER, 1L)).isTrue();
        }

        @Test
        void shouldClearOnlyStagedKeys() {
            BoundedScheduledCommandCache cache = BoundedScheduledCommandCache.ofIntent((ScheduledCommandCacheMetrics)NOOP_METRICS, (Intent[])new Intent[]{TimerIntent.TRIGGER});
            ScheduledCommandCache.StagedScheduledCommandCache staged = cache.stage();
            cache.add((Intent)TimerIntent.TRIGGER, 1L);
            staged.add((Intent)TimerIntent.TRIGGER, 2L);
            staged.clear();
            Assertions.assertThat((boolean)staged.contains((Intent)TimerIntent.TRIGGER, 2L)).isFalse();
            Assertions.assertThat((boolean)cache.contains((Intent)TimerIntent.TRIGGER, 1L)).isTrue();
        }
    }
}

