/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.exporter;

import io.camunda.zeebe.broker.exporter.debug.DebugLogExporter;
import io.camunda.zeebe.broker.system.configuration.ExporterCfg;
import io.camunda.zeebe.broker.test.EmbeddedBrokerRule;
import io.camunda.zeebe.exporter.api.context.Context;
import io.camunda.zeebe.exporter.api.context.Controller;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.test.broker.protocol.commandapi.CommandApiRule;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public final class ExporterManagerPartitionTest {
    private static final int PARTITIONS = 3;
    private static final String TEST_EXPORTER_ID = "test-exporter";
    public final EmbeddedBrokerRule brokerRule = new EmbeddedBrokerRule(brokerCfg -> {
        brokerCfg.getCluster().setPartitionsCount(3);
        ExporterCfg exporterCfg = new ExporterCfg();
        exporterCfg.setClassName(TestExporter.class.getName());
        brokerCfg.getExporters().put(TEST_EXPORTER_ID, exporterCfg);
    });
    public final CommandApiRule clientRule = new CommandApiRule(this.brokerRule::getAtomixCluster);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.brokerRule).around((TestRule)this.clientRule);

    @Test
    public void shouldRunExporterForEveryPartition() throws InterruptedException {
        IntStream.range(1, 4).forEach(this::createJob);
        Assertions.assertThat((boolean)TestExporter.CONFIGURE_LATCH.await(5L, TimeUnit.SECONDS)).isTrue();
        Assertions.assertThat((boolean)TestExporter.OPEN_LATCH.await(5L, TimeUnit.SECONDS)).isTrue();
        Assertions.assertThat((boolean)TestExporter.EXPORT_LATCH.await(5L, TimeUnit.SECONDS)).isTrue();
        this.brokerRule.stopBroker();
        Assertions.assertThat((boolean)TestExporter.CLOSE_LATCH.await(5L, TimeUnit.SECONDS)).isTrue();
    }

    void createJob(int partitionId) {
        this.clientRule.partitionClient(partitionId).createJob("test");
    }

    public static class TestExporter
    extends DebugLogExporter {
        static final CountDownLatch CONFIGURE_LATCH = new CountDownLatch(4);
        static final CountDownLatch OPEN_LATCH = new CountDownLatch(3);
        static final CountDownLatch CLOSE_LATCH = new CountDownLatch(3);
        static final CountDownLatch EXPORT_LATCH = new CountDownLatch(3);

        public void configure(Context context) {
            CONFIGURE_LATCH.countDown();
            super.configure(context);
        }

        public void open(Controller controller) {
            OPEN_LATCH.countDown();
            super.open(controller);
        }

        public void close() {
            CLOSE_LATCH.countDown();
            super.close();
        }

        public void export(Record<?> record) {
            if (record.getValueType() == ValueType.JOB && record.getIntent() == JobIntent.CREATED) {
                EXPORT_LATCH.countDown();
            }
            super.export(record);
        }
    }
}

