/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.exporter.context;

import io.camunda.zeebe.broker.exporter.context.ExporterConfiguration;
import io.camunda.zeebe.test.util.junit.RegressionTest;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

@Execution(value=ExecutionMode.CONCURRENT)
final class ExporterConfigurationTest {
    ExporterConfigurationTest() {
    }

    @ParameterizedTest
    @ValueSource(strings={"numberofshards", "numberOfShards", "NUMBEROFSHARDS"})
    void shouldInstantiateConfigWithCaseInsensitiveProperties(String property) {
        Map<String, Integer> args = Map.of(property, 1);
        Config expected = new Config(1);
        ExporterConfiguration config = new ExporterConfiguration("id", args);
        Config instance = (Config)config.instantiate(Config.class);
        Assertions.assertThat((Object)instance).isEqualTo((Object)expected);
    }

    @ParameterizedTest
    @ValueSource(strings={"numberofshards", "numberOfShards", "NUMBEROFSHARDS"})
    void shouldInstantiateNestedConfigWithCaseInsensitiveProperties(String property) {
        Map<String, Map<String, Integer>> args = Map.of("nested", Map.of(property, 1));
        ContainerConfig expected = new ContainerConfig(new Config(1));
        ExporterConfiguration config = new ExporterConfiguration("id", args);
        ContainerConfig instance = (ContainerConfig)config.instantiate(ContainerConfig.class);
        Assertions.assertThat((Object)instance).isEqualTo((Object)expected);
    }

    @Test
    void shouldInstantiateConfigWithUnknownProperty() {
        Map<String, Boolean> args = Map.of("numberofshards", 1, "unknownProp", false);
        Config expected = new Config(1);
        ExporterConfiguration config = new ExporterConfiguration("id", args);
        Config instance = (Config)config.instantiate(Config.class);
        Assertions.assertThat((Object)instance).isEqualTo((Object)expected);
    }

    @RegressionTest(value="https://github.com/camunda/camunda/issues/4552")
    void shouldInstantiateMapOfIntegersAsList() {
        Map<String, Map<String, Map<String, Integer>>> args = Map.of("configs", Map.of("0", Map.of("numberofshards", 0), "1", Map.of("numberofshards", 1)));
        ListConfig expected = new ListConfig(List.of(new Config(0), new Config(1)));
        ExporterConfiguration config = new ExporterConfiguration("id", args);
        ListConfig instance = (ListConfig)config.instantiate(ListConfig.class);
        Assertions.assertThat((Object)instance).isEqualTo((Object)expected);
    }

    @RegressionTest(value="https://github.com/camunda/camunda/issues/4552")
    void shouldInstantiateMapOfIntegersAsListNested() {
        Map<String, Map<String, Integer>> serializedConfigs = Map.of("0", Map.of("numberofshards", 0), "1", Map.of("numberofshards", 1));
        Map<String, Map<String, Map<String, Map<String, Map<String, Integer>>>>> args = Map.of("list", Map.of("0", Map.of("configs", serializedConfigs)));
        NestedListConfig expected = new NestedListConfig(List.of(new ListConfig(List.of(new Config(0), new Config(1)))));
        ExporterConfiguration config = new ExporterConfiguration("id", args);
        NestedListConfig instance = (NestedListConfig)config.instantiate(NestedListConfig.class);
        Assertions.assertThat((Object)instance).isEqualTo((Object)expected);
    }

    @RegressionTest(value="https://github.com/camunda/camunda/issues/4552")
    void shouldNotInstantiateSparseList() {
        Map<String, Map<String, Map<String, Integer>>> args = Map.of("configs", Map.of("1", Map.of("numberofshards", 0), "2", Map.of("numberofshards", 1)));
        ExporterConfiguration config = new ExporterConfiguration("id", args);
        ((AbstractThrowableAssert)Assertions.assertThatCode(() -> config.instantiate(ListConfig.class)).isInstanceOf(IllegalArgumentException.class)).hasRootCauseInstanceOf(IndexOutOfBoundsException.class);
    }

    @RegressionTest(value="https://github.com/camunda/camunda/issues/4552")
    void shouldNotInstantiateNonIntegerList() {
        Map<String, Map<String, Map<String, Integer>>> args = Map.of("configs", Map.of("foo", Map.of("numberofshards", 0), "bar", Map.of("numberofshards", 1)));
        ExporterConfiguration config = new ExporterConfiguration("id", args);
        ((AbstractThrowableAssert)Assertions.assertThatCode(() -> config.instantiate(ListConfig.class)).isInstanceOf(IllegalArgumentException.class)).hasRootCauseInstanceOf(NumberFormatException.class);
    }

    private record Config(int numberOfShards) {
    }

    private record ContainerConfig(Config nested) {
    }

    private record ListConfig(List<Config> configs) {
    }

    private record NestedListConfig(List<ListConfig> list) {
    }
}

